import sys
import os
import time as ptime

ignore = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)

modulename = sys.argv.pop(0)
clustername = sys.argv.pop(0)

servernames = []
jmsservernames = []
filestores = []
dirs = []
module2serversnames = []
while len(sys.argv) >= 5:
    servernames.append(sys.argv.pop(0))
    jmsservernames.append(sys.argv.pop(0))
    filestores.append(sys.argv.pop(0))
    dirs.append(sys.argv.pop(0))
    module2serversnames.append(sys.argv.pop(0))

#==============================#
# CreateMessageService         #
#==============================#
def createMessageService( clustername, modulename
                        , servernames, jmsservernames, filestores, dirs
                        , module2serversnames):
  """Create the complete messaging tree, from filestore up to JMS module.

  Keyword arguments:
  clustername -- A string with the name of the cluster
  modulename -- A string with the JMS module name
  servernames -- A list of strings with the (managed) server names
  jmsservernames -- A list of strings with a jmsservername for each servername
  filestores -- A list of string with a name (both file as logical) of the filestores for each jmsservername
  dirs -- A list of strings with a path to where the filestore dir will be created for each filestore
  module2serversnames -- A list of strings with a subdeployment name for each jmsservernames
  """
  log("Creating message service: "+modulename)
  createJMSModule(clustername, modulename)
  for i in range(0, len(servernames)):
    createJMSServer(servernames[i], jmsservernames[i], filestores[i], dirs[i])
    createSubDeployment(modulename, module2serversnames[i], jmsservernames[i])
  return 

#================#
# JMSModule      #
#================#
def createJMSModule(CLUSTERNAME, MODULENAME):
  log("Creating jmsmodule: "+MODULENAME+ " on target "+CLUSTERNAME)
  cd('/')
  if (cmo.lookupJMSSystemResource(MODULENAME) == None):  
      cmo.createJMSSystemResource(MODULENAME)
      targets = getClusterServerTargetArray(CLUSTERNAME)
      cd('/JMSSystemResources/' + MODULENAME)
      set('Targets',targets)
  return

#================#
# JMSServer      #
#================#
def createJMSServer(SERVERNAME, JMSSERVERNAME, FILESTORENAME, DIR):
  log("Creating jmsserver: "+JMSSERVERNAME)
  cd('/')
  cmo.createJMSServer(JMSSERVERNAME)
  cd('/')
  createFilestore(FILESTORENAME, DIR, SERVERNAME)
  cd('/JMSServers/' + JMSSERVERNAME)
  cmo.setPersistentStore(getMBean('/Deployments/' + FILESTORENAME))
  set('Targets',jarray.array([ObjectName('com.bea:Name=' + SERVERNAME + ',Type=Server')], ObjectName))
  return

#================#
# Filestore      #
#================#
def createFilestore(FILESTORENAME, DIR, SERVERNAME):
  log("Creating filestore: "+FILESTORENAME)
  cd('/')
  cmo.createFileStore(FILESTORENAME)
  cd('/Deployments/' + FILESTORENAME)
  cmo.setDirectory(DIR)
  cmo.setSynchronousWritePolicy('Cache-Flush')
  set('Targets',jarray.array([ObjectName('com.bea:Name=' + SERVERNAME + ',Type=Server')], ObjectName))
  return

#================#
# Subdeployment  #
#================#
def createSubDeployment(MODULENAME, DEPLOYMENTNAME, JMSSERVERNAME):
  log("Creating subdeployment: "+MODULENAME+" to "+JMSSERVERNAME)
  cd('/JMSSystemResources/' + MODULENAME)
  cmo.createSubDeployment(DEPLOYMENTNAME)
  cd('/JMSSystemResources/' + MODULENAME + '/SubDeployments/' + DEPLOYMENTNAME)
  set('Targets',jarray.array([ObjectName('com.bea:Name=' + JMSSERVERNAME + ',Type=JMSServer')], ObjectName))
  return

#=====================================#
# Get ClustServer Target Array        #
#=====================================#
def getClusterServerTargetArray(targetname):
  cd('/')
  try:
    target = lookup(targetname, 'Server')
    log("Server choosen: "+targetname)
  except WLSTException, reason:
    log("No server named "+targetname)
  try: 
    target = lookup(targetname, 'Cluster')
    log("Cluster choosen: "+targetname)
  except WLSTException, reason:
    log("No cluster named "+targetname)
  targetArray = jarray.array([ObjectName('com.bea:Name=' + target.getName() + ',Type='+target.getType())], ObjectName)
  return targetArray

#==============================#
# Logging method               #
#==============================#
def log(msg, level="info"):
    print ptime.strftime("%H:%M:%S", ptime.localtime()) + " <" + level + "> " + msg
    return

connect(user, password, url)
edit()
startEdit()
createMessageService(clustername, modulename, servernames, jmsservernames, filestores, dirs, module2serversnames)
save()
disconnect('true')
exit('y')
