#
# Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

from java.util import *
from javax.management import *
import sys
import time as ptime

scriptname = sys.argv.pop(0)
user = sys.argv.pop(0)
password = sys.argv.pop(0)
url = sys.argv.pop(0)
adminServerName = sys.argv.pop(0)

print "Connecting to WebLogic"
connect(user, password, url)

domainRuntime()
cd('/ServerRuntimes')
serverlines = ls().split('\n')
serverstorestart = []
for serverline in serverlines:
    serverlinefragments = serverline.split();
    if len(serverlinefragments) == 2:
        server = serverlinefragments[1]
        cd(server)
        if cmo.isRestartRequired():
            serverstorestart.append(server)
        cd('/ServerRuntimes')

cd('domainRuntime:/')
for servertorestart in serverstorestart:
    if servertorestart != adminServerName:
        print "Restarting " + servertorestart
        slBean = cmo.lookupServerLifeCycleRuntime(servertorestart)
        shutdownTaskMBean = slBean.shutdown()
        while shutdownTaskMBean.isRunning():
            print "Waiting for shutdown to complete (" + shutdownTaskMBean.getStatus() + ")"
            ptime.sleep(1)
        print "Shutdown task finished (" + shutdownTaskMBean.getStatus() + ")"

        print "Waiting 5 seconds before starting the server again"
        ptime.sleep(5)

        startTaskMBean = slBean.start()
        while startTaskMBean.isRunning():
            print "Waiting for startup to complete (" + startTaskMBean.getStatus() + ")"
            ptime.sleep(1)
        print "Startup task finished (" + startTaskMBean.getStatus() + ")"

print "Disconnecting from WebLogic"
disconnect('true')
exit('y')
