/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.steps.HostSessionStep;

public class CreateWlsJmsServerFilestorePathStep
extends HostSessionStep {
    private WlsJmsServer jmsServer;

    public CreateWlsJmsServerFilestorePathStep(WlsServer server, WlsJmsServer jmsServer) {
        super(server.getHost());
        this.jmsServer = jmsServer;
        this.setDescription("Create filestore path " + jmsServer.getFileStorePath() + " for JMS server " + jmsServer + " on host " + server.getHost() + ", if it does not already exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession s = this.getHostSession();
        try {
            HostFile filestoreDir = s.getFile(this.jmsServer.getFileStorePath());
            if (!filestoreDir.exists()) {
                ctx.logOutput("Creating filestore path " + this.jmsServer.getFileStorePath() + " for JMS server " + this.jmsServer + " on host " + this.host);
                filestoreDir.mkdirs();
            } else {
                ctx.logOutput("Filestore path " + this.jmsServer.getFileStorePath() + " for JMS server " + this.jmsServer + " on host " + this.host + " already exists");
            }
        }
        finally {
            s.close();
        }
        return true;
    }
}

