/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.mapper;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.ModificationSupportingMappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue;
import com.xebialabs.deployit.plugin.wls.ci.WlsServerResourceMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.CreateWlsJmsQueueStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyWlsJmsQueueStep;
import com.xebialabs.deployit.plugin.wls.step.ModifyWlsJmsQueueStep;

public class WlsJmsQueueToWlsServerMapper extends ModificationSupportingMappingAgnosticStepGeneratingMapper<WlsJmsQueue, WlsServerResourceMapping, WlsServer> {

	public WlsJmsQueueToWlsServerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(WlsJmsQueue queue, WlsServer server, List<Step> steps) {
		steps.add(new CreateWlsJmsQueueStep(server.getDomain(), JmsMapperUtils.getJmsModuleName(change, server), queue));
	}

	@Override
	protected void generateModificationStepsForModifiedMapping(WlsJmsQueue oldQueue, WlsServer oldServer, WlsJmsQueue queue, WlsServer server, List<Step> steps) {
		steps.add(new ModifyWlsJmsQueueStep(server.getDomain(), JmsMapperUtils.getJmsModuleName(change, server), queue));
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(WlsJmsQueue queue, WlsServer server, List<Step> steps) {
		steps.add(new DestroyWlsJmsQueueStep(server.getDomain(), JmsMapperUtils.getJmsModuleName(change, server), queue, server));
	}

}
