/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.util.TemplateResolver;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

/**
 */
@SuppressWarnings("serial")
public abstract class WlsWindowsServiceHandler implements Step {
	protected String serverName;
	protected String domainName;
	protected WlsServer server;

	static final int SERVICE_ALREADY_STARTED = 2182;
	static final int SERVICE_NOT_STARTED = 3521;

	public WlsWindowsServiceHandler(WlsServer server) {
		this.server = server;
		this.serverName = server.getName();
		this.domainName = server.getDomain().getName();
	}

	abstract String getTemplatePath();
	abstract String getCmdPrefix();

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = server.getHost().getHostSession();
		try {

			Map<String, String> context = Maps.newHashMap();
			context.put("serverName", serverName);
			context.put("domainName", domainName);

			final String evaluatedScript = generateWithTemplateResolver(getTemplatePath(), context);
			HostFile uploadedDeployScript = rhs.getTempFile(getCmdPrefix()+"-"+serverName, ".cmd");
			uploadedDeployScript.put(IOUtils.toInputStream(evaluatedScript), evaluatedScript.length());
			final WindowsServiceStepExecutionContextCallbackHandler stepHandler = new WindowsServiceStepExecutionContextCallbackHandler(ctx);
			final int retCode = rhs.execute(stepHandler, uploadedDeployScript.getPath().toString());
			System.out.println("RetCode "+retCode);
			System.out.println(stepHandler.getMessageNumber());
			if (retCode == 0) {
				return true;
			}
			else  {
				switch (stepHandler.getMessageNumber()) {
					case SERVICE_ALREADY_STARTED:
						return true;
					case SERVICE_NOT_STARTED:
						return true;
					default:
						return false;
				}

			} 
		}
		finally {
			rhs.close();
		}


	}

	protected String generateWithTemplateResolver(String templatePath, Map<String, String> context) {
		InputStream scriptIn;
		try {
			scriptIn = new ClassPathResource(templatePath).getInputStream();
		} catch (IOException exc) {
			throw new IllegalArgumentException("Cannot read script template resource " + templatePath, exc);
		}

		try {
			final String template = IOUtils.toString(scriptIn);
			final TemplateResolver r = new TemplateResolver(context);
			return r.resolveStrict(template);
		} catch (IOException exc) {
			throw new RuntimeException("Cannot evaluate script template resource " + templatePath, exc);
		} finally {
			IOUtils.closeQuietly(scriptIn);
		}
	}
}
