/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsMapperUtils {
    public static String getJmsModuleName(Change<Deployment> change, WlsTarget target) {
        if (change.getNewRevision() != null) {
            return JmsMapperUtils.getJmsModuleNameFromDeployment((Deployment)change.getNewRevision(), target);
        }
        return JmsMapperUtils.getJmsModuleNameFromDeployment((Deployment)change.getOldRevision(), target);
    }

    private static String getJmsModuleNameFromDeployment(Deployment d, WlsTarget target) {
        return JmsMapperUtils.sanitizeLabel(d.getSource().getApplication().getLabel()) + "-" + JmsMapperUtils.sanitizeLabel(target.getLabel());
    }

    private static String sanitizeLabel(String label) {
        return label.replace(' ', '_');
    }

    public static Set<WlsDomain> getDomains(Collection<WlsTarget> targets) {
        HashSet<WlsDomain> domains = new HashSet<WlsDomain>();
        for (WlsTarget each : targets) {
            domains.add(each.getDomain());
        }
        return domains;
    }
}

