/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.wls.ci.ApacheHttpdWlsPluginConfiguration;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.ApacheWlsPluginConfigFileStep;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateApacheHttpdWlsPluginConfigFileStep
extends ApacheWlsPluginConfigFileStep {
    private static Logger logger = Logger.getLogger(CreateApacheHttpdWlsPluginConfigFileStep.class);

    public CreateApacheHttpdWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, WlsCluster cluster, String virtualHost) {
        super(webServer, pluginConfiguration, cluster, virtualHost);
        this.setDescription("Generate Weblogic Apache Plugin configuration file on " + webServer.getHost());
    }

    public CreateApacheHttpdWlsPluginConfigFileStep(ApacheHttpdServer webServer, ApacheHttpdWlsPluginConfiguration pluginConfiguration, WlsServer server, String virtualHost) {
        super(webServer, pluginConfiguration, server, virtualHost);
        this.setDescription("Generate Weblogic Apache Plugin configuration file on " + webServer.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.webServer.connectToAdminHost();
        try {
            ctx.logOutput("Creating Apache Weblogic configuration file at " + this.wlConfigFilePath);
            HostFile apacheWlConfFile = hostSession.getFile(this.wlConfigFilePath);
            String apacheWLConfiguration = this.resolveUsingVelocity();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("resolved wl config template:" + apacheWLConfiguration));
            }
            apacheWlConfFile.put(IOUtils.toInputStream((String)apacheWLConfiguration), (long)apacheWLConfiguration.length());
            boolean bl = true;
            return bl;
        }
        finally {
            hostSession.close();
        }
    }

    private String resolveUsingVelocity() {
        String evaluatedScript;
        InputStream scriptIn;
        VelocityEngine ve = new VelocityEngine();
        try {
            ve.init();
        }
        catch (Exception exc) {
            throw new IllegalStateException("Cannot initialize Velocity templating engine", exc);
        }
        Map<String, Object> velocityContext = this.getVelocityContext();
        VelocityContext vc = new VelocityContext(velocityContext);
        ClassPathResource scriptResource = new ClassPathResource("com/xebialabs/deployit/plugin/wls/step/apache_wl_conf_template.vm");
        try {
            scriptIn = scriptResource.getInputStream();
        }
        catch (IOException exc) {
            throw new IllegalArgumentException("Cannot read script template resource com/xebialabs/deployit/plugin/wls/step/apache_wl_conf_template.vm", exc);
        }
        try {
            StringWriter evaluatedTemplateWriter = new StringWriter();
            ve.evaluate((Context)vc, (Writer)evaluatedTemplateWriter, " ", new InputStreamReader(scriptIn, "UTF-8"));
            evaluatedScript = evaluatedTemplateWriter.getBuffer().toString();
        }
        catch (IOException exc) {
            throw new RuntimeException("Cannot evaluate script template resource com/xebialabs/deployit/plugin/wls/step/apache_wl_conf_template.vm", exc);
        }
        finally {
            IOUtils.closeQuietly((InputStream)scriptIn);
        }
        return evaluatedScript;
    }

    private Map<String, Object> getVelocityContext() {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("usingVhost", this.usingVirtualHost);
        if (this.usingVirtualHost) {
            velocityContext.put("vhostServerName", this.virtualHostServerName);
            velocityContext.put("vhostPort", this.virtualHostPort);
            velocityContext.put("documentroot", this.webServer.getHtdocsDirPathForVirtualHost(this.virtualHost));
        }
        velocityContext.put("clusterSpecification", this.clusterSpecification);
        if (!StringUtils.isBlank((String)this.pluginConfiguration.getErrorPage())) {
            velocityContext.put("errorPage", this.pluginConfiguration.getErrorPage());
        }
        ArrayList<String> mimeExpressions = new ArrayList<String>();
        if (!StringUtils.isBlank((String)this.pluginConfiguration.getMimeMatchExpressions())) {
            String[] mimeMatchExpressions = StringUtils.split((String)this.pluginConfiguration.getMimeMatchExpressions(), (String)",");
            mimeExpressions.addAll(Arrays.asList(mimeMatchExpressions));
        }
        velocityContext.put("matchExpressions", mimeExpressions);
        ArrayList<String> pathExpressions = new ArrayList<String>();
        if (!StringUtils.isBlank((String)this.pluginConfiguration.getPathExpressions())) {
            String[] pathExpressionsArr = StringUtils.split((String)this.pluginConfiguration.getPathExpressions(), (String)",");
            pathExpressions.addAll(Arrays.asList(pathExpressionsArr));
        }
        velocityContext.put("locations", pathExpressions);
        return velocityContext;
    }
}

