/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.step;

import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;

@SuppressWarnings("serial")
public class CheckWlsClusterMemberNamesStep implements Step {
	
	private WlsCluster cluster;
	private Set<String> serverNames;
	
	private String additionalMessage;
	
	public CheckWlsClusterMemberNamesStep(WlsCluster cluster, Set<String> serverNames) {
		this.cluster = cluster;
		this.serverNames = serverNames;
		this.additionalMessage = null;
	}

	public boolean execute(StepExecutionContext ctx) {
		String containmentpath = "/Clusters/" + cluster.getName() + "/Servers";
		Map<String, String> objectOnfo = cluster.getDomain().getDirectoryObjectInfo(containmentpath);
		
		if (objectOnfo.keySet().size() != serverNames.size()) {
			StringBuilder sb = new StringBuilder();
			for (String foundServerName : objectOnfo.keySet()) {
				if (!serverNames.contains(foundServerName)) {
					String serverContainmentpath = "/Servers/" + foundServerName;
					Map<String, String> serverObjectOnfo = cluster.getDomain().getObjectInfo(serverContainmentpath);
					String port = serverObjectOnfo.get("ListenPort");
					sb.append("\nfound unknown server: " +  foundServerName + " on port " + port + "\n");
				}
			}
			for (String previouslyKnownServerName : serverNames) {
				if (!objectOnfo.keySet().contains(previouslyKnownServerName)) {
					sb.append("\ncan't find server named: " +  previouslyKnownServerName + " on cluster: " + cluster + "\n");
				}
			}
			additionalMessage = sb.toString();
			return false;
		}
		return true;
	}

	public String getDescription() {
		String result = "Check the list of servers in WebLogic cluster \"" + cluster.getLabel() + "\" on domain \"" + cluster.getDomain() + "\"";
		if (additionalMessage != null) {
			result = result + additionalMessage;
			additionalMessage = null;
		}
		return result;
	}

}
