/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wls.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheHttpdServer;
import com.xebialabs.deployit.plugin.apache.httpd.step.RestartApacheHttpdServerStep;
import com.xebialabs.deployit.plugin.wls.ci.ApacheHttpdWlsPluginConfiguration;
import com.xebialabs.deployit.plugin.wls.ci.ApacheHttpdWlsPluginConfigurationMapping;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.step.CreateApacheHttpdWlsPluginConfigFileStep;
import com.xebialabs.deployit.plugin.wls.step.DestroyApacheHttpdWlsPluginConfigFileStep;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Set;

public class ApacheHttpdWlsPluginConfigurationToApacheHttpdServerMapper extends
		StepGeneratingMapper<ApacheHttpdWlsPluginConfiguration, ApacheHttpdWlsPluginConfigurationMapping, ApacheHttpdServer> {

	public ApacheHttpdWlsPluginConfigurationToApacheHttpdServerMapper(Change<Deployment> change) {
		super(change);
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(ApacheHttpdWlsPluginConfiguration newSource, ApacheHttpdWlsPluginConfigurationMapping newMapping,
			ApacheHttpdServer newTarget, List<Step> steps) {
		Set<WlsCluster> exposedClusters = newMapping.getClusters();
		if (exposedClusters.size() != 1) {
			throw new ResolutionException("Can only expose exactly one WebLogic cluster, found "+ exposedClusters.size());
		}
		WlsCluster singleExposedCluster = (WlsCluster) CollectionUtils.get(exposedClusters, 0);
		steps.add(new CreateApacheHttpdWlsPluginConfigFileStep(newTarget, newSource, singleExposedCluster, newMapping.getVirtualHost()));
		steps.add(new RestartApacheHttpdServerStep(newTarget));
	}

	@Override
	protected void generateDeletionStepsForModifiedMapping(ApacheHttpdWlsPluginConfiguration oldSource, ApacheHttpdWlsPluginConfigurationMapping oldMapping,
			ApacheHttpdServer oldTarget, List<Step> steps) {
		//
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(ApacheHttpdWlsPluginConfiguration oldSource, ApacheHttpdWlsPluginConfigurationMapping oldMapping,
			ApacheHttpdServer oldTarget, List<Step> steps) {
		Set<WlsCluster> exposedClusters = oldMapping.getClusters();
		if (exposedClusters.size() != 1) {
			throw new ResolutionException("Can only expose exactly one WebLogic cluster");
		}
		WlsCluster singleExposedCluster = (WlsCluster) CollectionUtils.get(exposedClusters, 0);
		steps.add(new DestroyApacheHttpdWlsPluginConfigFileStep(oldTarget, oldSource, singleExposedCluster, oldMapping.getVirtualHost()));
		steps.add(new RestartApacheHttpdServerStep(oldTarget));
	}

	@Override
	public void setDefaults(Deployment d, ApacheHttpdWlsPluginConfigurationMapping m) {
		m.setVirtualHost(d.getVhostDefinition());
		m.setClusters(d.getTarget().getMembersOfType(WlsCluster.class));
	}

}
