/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.step.WlsStepBase;
import java.util.Collection;

public class CheckWlsServerIsOnCluster
extends WlsStepBase {
    public static final String IS_NOT_ON_RESULT = "IS_NOT_ON_CLUSTER";
    public static final String IS_ON_RESULT = "IS_ON_CLUSTER";
    public static final String SERVER_CLUSTER_SEPERATOR = "_ON_";
    private WlsCluster wlsCluster;
    private WlsServer discoveredServer;

    public CheckWlsServerIsOnCluster(WlsCluster wlsCluster, WlsServer discoveredServer) {
        super(wlsCluster.getDomain());
        this.wlsCluster = wlsCluster;
        this.discoveredServer = discoveredServer;
        this.setDescription("Check that server " + (Object)((Object)discoveredServer) + " is on cluster " + (Object)((Object)wlsCluster));
    }

    public boolean execute(StepExecutionContext ctx) {
        Collection<String> servernamesOnCluster = this.domain.getObjectInfoWithSubLevelByTypeNamesOnly(ctx, "/Clusters/" + this.wlsCluster.getName() + "/Servers");
        String isOn = servernamesOnCluster.contains(this.discoveredServer.getName()) ? IS_ON_RESULT : IS_NOT_ON_RESULT;
        ctx.setAttribute((Object)((Object)this.discoveredServer) + SERVER_CLUSTER_SEPERATOR + (Object)((Object)this.wlsCluster), (Object)isOn);
        return true;
    }
}

