/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.plugin.wls.ci.WlsCluster;
import com.xebialabs.deployit.plugin.wls.ci.WlsDomain;
import com.xebialabs.deployit.plugin.wls.ci.WlsServer;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StartWlsServerWithWindowsService;
import com.xebialabs.deployit.plugin.wls.step.StopWlsServerStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsServerWithScriptStep;
import com.xebialabs.deployit.plugin.wls.step.StopWlsServerWithWindowsService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartStopStepFactory {
    public Step getStartStep(WlsServer server) {
        WlsDomain domain = server.getDomain();
        switch (domain.getStartMode()) {
            case NodeManager: {
                return new StartWlsServerStep(server);
            }
            case Script: {
                return new StartWlsServerWithScriptStep(server);
            }
            case WindowsService: {
                return new StartWlsServerWithWindowsService(server);
            }
        }
        throw new RuntimeException("StartMode unknown " + (Object)((Object)domain.getStartMode()));
    }

    public Step getStopStep(WlsServer server) {
        WlsDomain domain = server.getDomain();
        switch (domain.getStartMode()) {
            case NodeManager: {
                return new StopWlsServerStep(server);
            }
            case Script: {
                return new StopWlsServerWithScriptStep(server);
            }
            case WindowsService: {
                return new StopWlsServerWithWindowsService(server);
            }
        }
        throw new RuntimeException("StartMode unknown " + (Object)((Object)domain.getStartMode()));
    }

    public Set<Step> getStartStep(WlsTarget target) {
        if (target instanceof WlsServer) {
            return Collections.singleton(this.getStartStep((WlsServer)target));
        }
        if (target instanceof WlsCluster) {
            WlsCluster cluster = (WlsCluster)target;
            HashSet steps = Sets.newHashSet();
            for (WlsServer s : cluster.getServers()) {
                steps.add(this.getStartStep(s));
            }
            return steps;
        }
        throw new RuntimeException("WlsTarget unknown " + (Object)((Object)target));
    }

    public Set<Step> getStopStep(WlsTarget target) {
        if (target instanceof WlsServer) {
            return Collections.singleton(this.getStopStep((WlsServer)target));
        }
        if (target instanceof WlsCluster) {
            WlsCluster cluster = (WlsCluster)target;
            HashSet steps = Sets.newHashSet();
            for (WlsServer s : cluster.getServers()) {
                steps.add(this.getStopStep(s));
            }
            return steps;
        }
        throw new RuntimeException("WlsTarget unknown " + (Object)((Object)target));
    }
}

