/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wls.ci.WlsTarget;
import com.xebialabs.deployit.plugin.wls.step.Wls8WeblogicDeployerStepBase;
import java.util.HashMap;

public class Wls8DeployNoStageArtifactStep
extends Wls8WeblogicDeployerStepBase
implements Step {
    private String extension;
    private String targetName;
    private String applicationName;
    private String remoteArchivePath;

    public Wls8DeployNoStageArtifactStep(WlsTarget target, NamedDeployableArtifact artifact, String remoteArchivePath) {
        super(target.getDomain());
        this.targetName = target.getName();
        this.applicationName = artifact.getName();
        this.extension = this.findOutExtension(artifact);
        this.remoteArchivePath = remoteArchivePath;
        this.setDescription("Deploy  " + artifact + " on " + (Object)((Object)target) + " nostage mode using " + remoteArchivePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.domain.connectToAdminHost();
        try {
            HashMap velocityContext = Maps.newHashMap();
            velocityContext.put("username", this.domain.getUsername());
            velocityContext.put("password", this.domain.getPassword());
            velocityContext.put("adminurl", this.domain.getConnectUrl());
            velocityContext.put("wlHome", this.domain.getWlHome());
            velocityContext.put("uploadedApplication", this.remoteArchivePath);
            velocityContext.put("target", this.targetName);
            velocityContext.put("name", this.applicationName);
            velocityContext.put("deployerAction", "-upload -nostage  -deploy " + this.remoteArchivePath);
            boolean bl = this.executeWeblogicDeployerScript(ctx, rhs, velocityContext) == 0;
            return bl;
        }
        finally {
            rhs.close();
        }
    }
}

