package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

@SuppressWarnings("serial")
@ConfigurationItem
public class WmqLocalQueue extends BaseConfigurationItem {

	@ConfigurationItemProperty(description = "Name of the queue in WebSphere MQ", identifying = true)
	private String name;

	@ConfigurationItemProperty(description = "Maximum number of message in the queue")
	private int maxDepth;

	@ConfigurationItemProperty(description = "Whether messages in the queue shuold be persisted")
	private boolean isPersistent;

	public WmqLocalQueue() {
		// no-op
	}

	public WmqLocalQueue(String label, String name) {
		this.label = label;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getMaxDepth() {
		return maxDepth;
	}

	public void setMaxDepth(int maxDepth) {
		this.maxDepth = maxDepth;
	}

	public boolean isPersistent() {
		return isPersistent;
	}

	public void setPersistent(boolean isPersistent) {
		this.isPersistent = isPersistent;
	}

}
