package com.xebialabs.deployit.plugin.wmq.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.plugin.wmq.ci.WmqLocalQueue;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;

@SuppressWarnings("serial")
class CreateOrModifyWmqLocalQueueStep implements Step {

	private WmqQueueManager queueManager;

	private WmqLocalQueue queue;

	private boolean modify;

	public CreateOrModifyWmqLocalQueueStep(WmqQueueManager queueManager, WmqLocalQueue queue, boolean modify) {
		this.queueManager = queueManager;
		this.queue = queue;
		this.modify = modify;
	}

	public boolean execute(StepExecutionContext ctx) {
		CommandExecutionCallbackHandler handler = new StepExecutionContextCallbackHandler(ctx);
		StringBuffer defineCommand = new StringBuffer();
		defineCommand.append(modify ? "ALTER" : "DEFINE");
		defineCommand.append(" QLOCAL(");
		defineCommand.append(queue.getName());
		defineCommand.append(")");
		if (queue.getMaxDepth() > 0) {
			defineCommand.append(" MAXDEPTH(");
			defineCommand.append(queue.getMaxDepth());
			defineCommand.append(")");
		}
		defineCommand.append(" DEFPSIST(");
		defineCommand.append(queue.isPersistent() ? "YES" : "NO");
		defineCommand.append(")");
		int exitValue = queueManager.executeRunMqscCommand(defineCommand.toString(), handler);
		return exitValue == 0;
	}

	public String getDescription() {
		return (modify ? "Modify" : "Create") + " queue " + queue + " on queue manager " + queueManager;
	}

}
