/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "Listener objects are used to accept incoming network requests from remote queue managers, or client applications. Once accepted, a listener starts the associated receiver or server connection channels to allow the queue manager to receive messages.")
public class WmqNetBIOSListener extends WmqListener {

	@ConfigurationItemProperty(label = "Adapter", description = "The adapter number on which NetBIOS listens. This is valid only on Windows")
	private int adapter;

	@ConfigurationItemProperty(label = "Local name", description = "The NetBIOS local name that the listener uses. This is valid only on Windows. ")
	private String localName;

	@ConfigurationItemProperty(label = "Name count", description = "The number of names that the listener supports. This is valid only on Windows.")
	private int nameCount;

	@ConfigurationItemProperty(label = "Session count", description = "The number of sessions that the listener can use. This is valid only on Windows. ")
	private int sessionCount;

	@ConfigurationItemProperty(label = "Command count", description = "The number of commands that the listener can use. This is valid only on Windows. ")
	private int commandCount;

	public int getAdapter() {
		return adapter;
	}

	public void setAdapter(int adapter) {
		this.adapter = adapter;
	}

	public String getLocalName() {
		return localName;
	}

	public void setLocalName(String localName) {
		this.localName = localName;
	}

	public int getNameCount() {
		return nameCount;
	}

	public void setNameCount(int nameCount) {
		this.nameCount = nameCount;
	}

	public int getSessionCount() {
		return sessionCount;
	}

	public void setSessionCount(int sessionCount) {
		this.sessionCount = sessionCount;
	}

	public int getCommandCount() {
		return commandCount;
	}

	public void setCommandCount(int commandCount) {
		this.commandCount = commandCount;
	}

}
