/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ConfigurationItemProperty.Size;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.plugin.wmq.enums.WmqAccountingConnOverride;
import com.xebialabs.deployit.plugin.wmq.enums.WmqActivityRecording;
import com.xebialabs.deployit.plugin.wmq.enums.WmqAuthorityEvent;
import com.xebialabs.deployit.plugin.wmq.enums.WmqAutoCLUSSDRMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqAutoCLUSSDRStatistics;
import com.xebialabs.deployit.plugin.wmq.enums.WmqCLWLUseQueueQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelAutoDefinition;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelAutoDefinitionEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelInitControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoringQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypesQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqCommandServerControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqIPAddressVersion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqInhibitEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqLocalEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqLoggerEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMQIAccounting;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMQIStatistics;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPerformanceEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPublishSubscribeMode;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPublishSubscribeSyncPoint;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueAccountingQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueMonitoringQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqQueueStatisticsQManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqRemoteEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSSLEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSslFipsRequired;
import com.xebialabs.deployit.plugin.wmq.enums.WmqStartAndStopEvents;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTraceRouteRecording;
import com.xebialabs.deployit.plugin.wmq.enums.WmqUndeliveredNonPersistentInputMessage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqUndeliveredNonPersistentResponse;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.CheckWmqChannelStep;
import com.xebialabs.deployit.plugin.wmq.step.CheckWmqListenerPortStep;
import com.xebialabs.deployit.plugin.wmq.step.DisplayWmqCmdServerStatusStep;
import com.xebialabs.deployit.plugin.wmq.step.DisplayWmqQueueManagerStatusStep;
import com.xebialabs.deployit.plugin.wmq.step.InquireWmqQueueManagerClusterStep;
import com.xebialabs.deployit.plugin.wmq.step.InquireWmqQueueManagerStep;
import com.xebialabs.deployit.plugin.wmq.step.InquireWmqTCPListenerStep;
import com.xebialabs.deployit.plugin.wmq.step.RetrieveWmqListenerNamesStep;
import com.xebialabs.deployit.plugin.wmq.step.RetrieveWmqQueueManagerNamesStep;
import com.xebialabs.deployit.plugin.wmq.step.RetrieveWmqVersionStep;

@SuppressWarnings({ "serial" })
@ConfigurationItem(category = "middleware", description = "The QueueManager itself started during the Discovery process.The MQQueueManager object represents a queue manager hosted by a particular machine. Enumerating the MQQueueManager object provides access to the items it contains (MQClntConnChannel, MQClusterReceiverChannel, MQClusterSenderChannel, MQReceiverChannel, MQRequesterChannel, MQSenderChannel, MQServerChannel, MQSvrConnChannel, MQProcess, MQAliasQueue, MQClusterQueue, MQLocalQueue, MQModelQueue, and MQRemoteQueue).")
public class WmqQueueManager extends WmqTarget implements Discoverable<WmqQueueManager> {

	private static final String QUEUE_MANAGER_NAMES = "WmqQueueManagersNames";

	// Name of the QueueManager.
	@ConfigurationItemProperty(required = true, label = "QueueManager name", identifying = true, description = "specify the name of the QueueManager", size = Size.MEDIUM)
	private String queueManagerName;

	// Host name.
	@ConfigurationItemProperty(required = true, label = "Host name", identifying = true, description = "specify the hostname", size = Size.MEDIUM)
	private Host hostName;

	// Port number of the Queuename.
	@ConfigurationItemProperty(required = true, label = "Port number", identifying = true, description = "specify the port number", size = Size.SMALL)
	private int portNumber;

	// Name of the Channel.
	@ConfigurationItemProperty(required = true, label = "Channel name", identifying = true, description = "specify the server connection channel name", size = Size.LARGE)
	private String channelName;

	// Version of MQSeries.
	@ConfigurationItemProperty(required = true, label = "WMQ version", description = "version of MQ series.")
	private WmqVersion version;

	public Host getHostName() {
		return hostName;
	}

	public void setHostName(Host hostName) {
		this.hostName = hostName;
	}

	public int getPortNumber() {
		return portNumber;
	}

	public void setPortNumber(int portNumber) {
		this.portNumber = portNumber;
	}

	public String getChannelName() {
		return channelName;
	}

	public void setChannelName(String channelName) {
		this.channelName = channelName;
	}

	public WmqVersion getVersion() {
		return version;
	}

	public void setVersion(WmqVersion version) {
		this.version = version;
	}

	public WmqQueueManager discover(Map<String, Object> info, ChangePlan cp) {
		List steps = getCheckSteps();
		cp.addSteps(steps);
		cp.execute(info);
		setQueueManagerDiscoveredName(info);
		setQManagerDetails(info, cp, this);
		discoverOtherQMgrs(info, cp);
		return this;
	}

	public WmqQueueManager discoverChildrenInfo(Map<String, Object> discoveredAdditionalInfo, ChangePlan cp) {
		List steps = new ArrayList();
		steps.add(new RetrieveWmqListenerNamesStep(this));

		List<WmqQueueManager> discoveredQManagers = (List<WmqQueueManager>) discoveredAdditionalInfo
		        .get("com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager");
		for (WmqQueueManager wmqQueueManager : discoveredQManagers) {
			steps.add(new RetrieveWmqListenerNamesStep(wmqQueueManager));
		}
		cp.addSteps(steps);
		cp.execute(discoveredAdditionalInfo);
		discoverListener(discoveredAdditionalInfo, cp, this);
		for (WmqQueueManager wmqQueueManager : discoveredQManagers) {
			discoverListener(discoveredAdditionalInfo, cp, wmqQueueManager);
		}

		return this;
	}

	private void discoverListener(Map<String, Object> discoveredAdditionalInfo, ChangePlan cp, WmqQueueManager queueManager) {
		if (discoveredAdditionalInfo.containsKey(queueManager.queueManagerName + ":LISTENER")) {
			List<WmqTCPListener> tcpListeners = new ArrayList<WmqTCPListener>();
			for (String tcpListenerName : (Collection<String>) discoveredAdditionalInfo.get(queueManager.queueManagerName + ":LISTENER")) {
				WmqTCPListener tcpListener = new WmqTCPListener();
				tcpListener.setListenerName(tcpListenerName);
				setListenerDetails(discoveredAdditionalInfo, cp, tcpListener, queueManager);
				tcpListener.setWmqQueueManager(queueManager);
				tcpListeners.add(tcpListener);
			}

			if (discoveredAdditionalInfo.get("com.xebialabs.deployit.plugin.wmq.ci.WmqTCPListener") == null) {
				discoveredAdditionalInfo.put("com.xebialabs.deployit.plugin.wmq.ci.WmqTCPListener", tcpListeners);
			} else {
				List existingListeners = (List) discoveredAdditionalInfo.get("com.xebialabs.deployit.plugin.wmq.ci.WmqTCPListener");
				existingListeners.addAll(tcpListeners);
				discoveredAdditionalInfo.put("com.xebialabs.deployit.plugin.wmq.ci.WmqTCPListener", existingListeners);
			}
			discoveredAdditionalInfo.remove(queueManager.queueManagerName + ":LISTENER");
		}
	}

	private void setListenerDetails(Map<String, Object> discoveredAdditionalInfo, ChangePlan cp, WmqTCPListener tcpListener, WmqQueueManager queueManager) {

		List steps = getListenerSteps(queueManager, tcpListener);
		cp.addSteps(steps);
		cp.execute(discoveredAdditionalInfo);

	}

	private List getListenerSteps(WmqQueueManager queueManager, WmqTCPListener tcpListener) {
		List steps = new ArrayList();

		steps.add(new InquireWmqTCPListenerStep(tcpListener, queueManager));
		return steps;
	}

	private void discoverOtherQMgrs(Map<String, Object> discoveredAdditionalInfo, ChangePlan cp) {
		if (discoveredAdditionalInfo.containsKey(QUEUE_MANAGER_NAMES)) {
			List<WmqQueueManager> discoveredQManagers = new ArrayList<WmqQueueManager>();
			for (String QName : (Collection<String>) discoveredAdditionalInfo.get(QUEUE_MANAGER_NAMES)) {
				WmqQueueManager wmqQueueManger = new WmqQueueManager();
				wmqQueueManger.setQueueManagerName(QName);
				setQManagerDetails(discoveredAdditionalInfo, cp, wmqQueueManger);
				discoveredQManagers.add(wmqQueueManger);
			}

			discoveredAdditionalInfo.put("com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager", discoveredQManagers);
			discoveredAdditionalInfo.remove(QUEUE_MANAGER_NAMES);
		}
	}

	private void setQueueManagerDiscoveredName(Map<String, Object> info) {
		if (info.containsKey(QUEUE_MANAGER_NAMES)) {

			List<String> qManagerList = (List<String>) info.get(QUEUE_MANAGER_NAMES);
			this.setQueueManagerName(qManagerList.get(0));
			qManagerList.remove(0);
			info.put(QUEUE_MANAGER_NAMES, qManagerList);

		}

	}

	private void setQManagerDetails(Map<String, Object> discoveredAdditionalInfo, ChangePlan cp, WmqQueueManager wmqQueueManger) {

		wmqQueueManger.setHostName(this.hostName);
		List steps = getQManagerSteps(wmqQueueManger);
		wmqQueueManger.setVersion(this.getVersion());
		cp.addSteps(steps);
		cp.execute(discoveredAdditionalInfo);
	}

	private List getCheckSteps() {
		List steps = new ArrayList();
		steps.add(new RetrieveWmqVersionStep(this));
		steps.add(new RetrieveWmqQueueManagerNamesStep(this.getHostName()));
		return steps;
	}

	private List getQManagerSteps(WmqQueueManager queueManger) {
		List steps = new ArrayList();
		steps.add(new DisplayWmqQueueManagerStatusStep(queueManger));
		steps.add(new DisplayWmqCmdServerStatusStep(queueManger));
		steps.add(new CheckWmqChannelStep(queueManger));
		steps.add(new CheckWmqListenerPortStep(queueManger));
		steps.add(new InquireWmqQueueManagerStep(queueManger));
		steps.add(new InquireWmqQueueManagerClusterStep(queueManger));
		return steps;
	}

	/************************************************************************************/
	// These properties are discovered for Queue Manager and used only for information(display) purpose.
	/************************************************************************************/

	@ConfigurationItemProperty(label = "This queue manager is a member of these clusters:", description = "This queue manager is a member of these clusters.", category = "Cluster")
	private String clusterName;

	@ConfigurationItemProperty(label = "Platform", description = "This is the architecture of the platform on which the queue manager is running.")
	private int platform;

	@ConfigurationItemProperty(label = "Coded character set identifier ", identifying = true, description = "Specifies the coded character set identifier for the queue manager.")
	private int codedCharacterSetIdentifier;

	@ConfigurationItemProperty(label = "Description ", identifying = true, description = "Type a meaningful description of the purpose of the queue manager.")
	private String qManagerDescription;

	@ConfigurationItemProperty(label = "Command level ", identifying = true, description = "This is the function level of the queue manager.")
	private int commandLevel;

	@ConfigurationItemProperty(label = "Command server control", identifying = true, description = "To configure the command server so that it starts automatically.")
	private WmqCommandServerControl commandServerControl;

	@ConfigurationItemProperty(label = "Channel init control  ", identifying = true, description = "To configure the channel initiator so that it starts automatically when the queue manager starts, click Queue Manager; to configure the channel initiator so that it does not start automatically and must be started manually, click Manual.")
	private WmqChannelInitControl channelInitControl;

	@ConfigurationItemProperty(label = "Dead-letter queue ", identifying = true, description = "Select the name of the queue that the queue manager uses as the dead-letter queue,", category = "Extended")
	private String deadLetterQueue;

	@ConfigurationItemProperty(label = "Trigger interval ", identifying = true, description = "from 0 to 999 999 999,", category = "Extended")
	private int triggerInterval;

	@ConfigurationItemProperty(label = "Max uncommitted messages ", identifying = true, description = "Type the maximum number of uncommitted messages within a syncpoint, from 1 to 999 999 999, to limit the number of messages that can be retrieved and put within any single syncpoint,", category = "Extended")
	private int maxUnCommittedMessages;

	@ConfigurationItemProperty(label = "Max handles ", identifying = true, description = "Type the maximum number of open handles, from 0 to 999 999 999, that any one task can have at the same time,", category = "Extended")
	private int maxHandles;

	@ConfigurationItemProperty(label = "Max message length ", identifying = true, description = "Type the maximum length of messages, from 32 KB to 100 MB, that is allowed on queues on the queue manager. The default value is 4 MB (4 194 304 bytes). ", category = "Extended")
	private int maxMessageLength;

	@ConfigurationItemProperty(label = "Message mark browse interval ", identifying = true, description = "Type the time interval in milliseconds after which the queue manager automatically un-marks browsed messages. The interval can be set from 0 to 999 999 999 milliseconds. The interval can also be set to Unlimited. The default value is 5000.),", category = "Extended")
	private int messageMarkBrowseInterval;

	@ConfigurationItemProperty(label = "Max properties length ", identifying = true, description = "This value controls the size in bytes of the property data that can flow with messages in a V7 queue manager. If the size of the properties exceeds the maximum properties length then the message is rejected.", category = "Extended")
	private int maxPropertiesLength;

	@ConfigurationItemProperty(label = "Max priority ", identifying = true, description = "This is the maximum priority of the queue manager, which is 9.", category = "Extended")
	private int maxPriority;

	@ConfigurationItemProperty(label = "Command input queue ", identifying = true, description = "This is the name of the system-command input queue. Suitably authorized applications can put commands on this queue,", category = "Extended")
	private String commandInputQueue;

	@ConfigurationItemProperty(label = "Distribution lists", identifying = true, description = "This attribute states whether the queue manager supports distribution lists", category = "Extended")
	private int distributionLists;

	@ConfigurationItemProperty(label = "Syncpoint ", identifying = true, description = "This attribute states whether syncpoint is available with the queue manager.", category = "Extended")
	private int syncpoint;

	@ConfigurationItemProperty(label = "Cluster workload exit ", identifying = true, description = "The exit is called when a message is put on a cluster queue. Type the name of the cluster workload exit.", category = "Cluster")
	private String clusterWorkLoadExit;

	@ConfigurationItemProperty(label = "Cluster Workload Data ", identifying = true, description = "Type the data to be passed to the cluster workload exit when the exit is called. The maximum length of the data is 32 characters.", category = "Cluster")
	private String clusterWorkloadData;

	@ConfigurationItemProperty(label = "Cluster Workload Length ", identifying = true, description = "Type the maximum number of bytes of message data that is passed to the cluster workload exit.", category = "Cluster")
	private int clusterWorkloadLength;

	@ConfigurationItemProperty(label = "maxOutBoundClusterChannels ", identifying = true, description = "Type the maximum number of outbound cluster channels.Range 0 to 999999999.", category = "Cluster")
	private int maxOutBoundClusterChannels;

	@ConfigurationItemProperty(label = "CLWLUseQueue  ", identifying = true, description = "This attribute specifies whether the queue manager can choose from remote instances of cluster queues as well as local instances.", category = "Cluster")
	private WmqCLWLUseQueueQManager clwlUseQueue;

	@ConfigurationItemProperty(label = "Full Repository For a Cluster  ", editable = true, identifying = true, description = "To make this queue manager a full repository for just one cluster, select this option, then type the name of the cluster. ", category = "Repository")
	private String fullRepositoryForaCluster;

	@ConfigurationItemProperty(label = "Full Repository For List Of Clusters  ", hasClass = true, identifying = true, description = "To make this queue manager a full repository for more than one cluster, select this option, then type the name of the cluster.", category = "Repository")
	private String fullRepositoryForListOfClusters;

	@ConfigurationItemProperty(label = "Default transmission queue", identifying = true, description = "Type the name of the default transmission queue on which messages that are destined for a remote queue manager are put if there is no other suitable transmission queue defined. The queue named must be a local transmission queue.", category = "Communication")
	private String defaultTransmissionQueue;

	@ConfigurationItemProperty(label = "Channel auto definition ", identifying = true, description = "To enable receiver- and server-connection channels to be defined automatically,", category = "Communication")
	private WmqChannelAutoDefinition channelAutoDefinition;

	@ConfigurationItemProperty(label = "Channel auto definition exit", identifying = true, description = "The exit is called when an inbound request for an undefined receiver, server-connection, or cluster-sender channel is received.", category = "Communication")
	private String channelAutoDefinitionExit;

	@ConfigurationItemProperty(label = "IP address version ", identifying = true, description = "To specify that the queue manager uses the IPv6 protocol, click IPV6; to specify that the queue manager uses the IPv4 protocol, click IPV4.", category = "Communication")
	private WmqIPAddressVersion ipAddressVersion;

	@ConfigurationItemProperty(label = "Activity recording ", identifying = true, description = "If a queue manager application performs some work on behalf of a message in which activity reports were requested, the queue manager can generate an activity report.", category = "Communication")
	private WmqActivityRecording activityRecording;

	@ConfigurationItemProperty(label = "Trace-Route recording ", identifying = true, description = "You can use Trace-Route messages to determine the routes that messages take through a queue manager network.", category = "Communication")
	private WmqTraceRouteRecording traceRouteRecording;

	@ConfigurationItemProperty(label = "AuthorityEvent ", identifying = true, description = "The MQI AuthorityEvent attribute.", category = "Events")
	private WmqAuthorityEvent authorityEvent;

	@ConfigurationItemProperty(label = "Inhibit events ", identifying = true, description = "When an application tries to put a message on a queue that is put-inhibited, or to get a message from a queue that is get-inhibited, the queue manager can generate an inhibit event message", category = "Events")
	private WmqInhibitEvents inhibitEvents;

	@ConfigurationItemProperty(label = "Local events ", identifying = true, description = "When an application or the queue manager has not been able to access an object, for example because the object has not been defined, the queue manager can generate a local event message.", category = "Events")
	private WmqLocalEvents localEvents;

	@ConfigurationItemProperty(label = "Remote events ", identifying = true, description = "When an application or the queue manager cannot access a queue on another queue manager, for example the transmission queue is not correctly defined, the queue manager can generate a remote event message. To generate remote event messages, ", category = "Events")
	private WmqRemoteEvents remoteEvents;

	@ConfigurationItemProperty(label = "Start and stop events ", identifying = true, description = "When a queue manager starts , or has been requested to stop or quiesce (z/OS supports only start), the queue manager can generate a start and stop event message.", category = "Events")
	private WmqStartAndStopEvents startAndStopEvents;

	@ConfigurationItemProperty(label = "Performance events ", identifying = true, description = "When a resource reaches a threshold condition, for example a queue depth limit has been reached, the queue manager can generate a performance event message.", category = "Events")
	private WmqPerformanceEvents performanceEvents;

	@ConfigurationItemProperty(label = "Channel events  ", identifying = true, description = "When the queue manager detects certain conditions on a channel, for example the channel starts or stops, the queue manager can generate channel event messages. ", category = "Events")
	private WmqChannelEvents channelEvents;

	@ConfigurationItemProperty(label = "Channel auto definition events  ", identifying = true, description = "When a channel is automatically generated, the queue manager can generate a channel auto-definition event message.", category = "Events")
	private WmqChannelAutoDefinitionEvents channelAutoDefinitionEvents;

	@ConfigurationItemProperty(label = "SSL events ", identifying = true, description = "When a channel that uses Secure Sockets Layer (SSL) security fails to establish an SSL connection, the queue manager can generate an SSL event message. ", category = "Events")
	private WmqSSLEvents sslEvents;

	@ConfigurationItemProperty(label = "Logger events ", identifying = true, description = "When changes are written to the WebSphere MQ recovery log, the queue manager can generate a logger event message.", category = "Events")
	private WmqLoggerEvents loggerEvents;

	@ConfigurationItemProperty(label = "Revocation namelist ", identifying = true, description = "Type the name of the revocation namelist.", category = "Ssl")
	private String revocationNameList;

	@ConfigurationItemProperty(label = "Cryptographic hardware ", identifying = true, description = "To configure your cryptographic hardware, click Configure... In the Cryptographic hardware settings dialog, enter the details of your cryptographic hardware.", category = "Ssl")
	private String cryptographicHardware;

	@ConfigurationItemProperty(label = "SSL FIPS required  ", identifying = true, description = "To specify that only FIPS-certified cryptographic algorithms can be used, ", category = "Ssl")
	private WmqSslFipsRequired sslFipsRequired;

	@ConfigurationItemProperty(label = "Key repository  ", identifying = true, description = "Type the full path to the key repository for the queue manager.", category = "Ssl")
	private String keyRepository;

	@ConfigurationItemProperty(label = "SSL Reset Count   ", identifying = true, description = "Type the number of unencrypted bytes, from 0 to 999 999 999, that are sent and received within an SSL conversation before the secret key is renegotiated.", category = "Ssl")
	private int sslResetCount;

	@ConfigurationItemProperty(label = "Alteration date    ", identifying = true, description = "This is the date on which the queue's attributes were last altered.", category = "Statistics")
	private String alterationDate;

	@ConfigurationItemProperty(label = "Alteration time ", identifying = true, description = "This is the time at which the queue's attributes were last altered. ", category = "Statistics")
	private String alterationTime;

	@ConfigurationItemProperty(label = "QMID", identifying = true, description = "This is the internally-generated unique name of the queue manager.", category = "Statistics")
	private String qmid;

	@ConfigurationItemProperty(label = "Creation date", identifying = true, description = "This is the date on which the queue was created. ", category = "Statistics")
	private String creationDate;

	@ConfigurationItemProperty(label = "Creation time", identifying = true, description = "This is the time at which the queue was created.  ", category = "Statistics")
	private String creationTime;

	@ConfigurationItemProperty(label = "Channel monitoring ", identifying = true, description = "This attribute specifies whether to collect online monitoring data about the current performance of channels hosted by the queue manager.", category = "Online monitering")
	private WmqChannelMonitoringQManager channelMonitoring;

	@ConfigurationItemProperty(label = "Queue monitoring  ", identifying = true, description = "This attribute specifies whether to collect online monitoring data about the current performance of queues hosted by the queue manager.", category = "Online monitering")
	private WmqQueueMonitoringQManager queueMonitoring;

	@ConfigurationItemProperty(label = "Auto CLUSSDR monitoring", identifying = true, description = "This attribute specifies whether to collect online monitoring data about the current performance of auto-defined cluster-sender channels.", category = "Online monitering")
	private WmqAutoCLUSSDRMonitoring autoClussdrMonitoring;

	@ConfigurationItemProperty(label = "MQI Statistics ", identifying = true, description = "To collect MQI statistics data for the queue manager, click On; to prevent MQI statistics monitoring data collection for the queue manager, click Off.", category = "Statistics monitoring")
	private WmqMQIStatistics mqiStatistics;

	@ConfigurationItemProperty(label = "Queue Statistics ", identifying = true, description = "This attribute specifies whether to collect statistics data about the activity of queues hosted by the queue manager", category = "Statistics monitoring")
	private WmqQueueStatisticsQManager queueStatistics;

	@ConfigurationItemProperty(label = "Channel Statistics ", identifying = true, description = "This attribute specifies whether to collect statistics data about the activity of channels hosted by the queue manager.", category = "Statistics monitoring")
	private WmqChannelStatisticTypesQManager channelStatistics;

	@ConfigurationItemProperty(label = "Auto CLUSSDR Statistics  ", identifying = true, description = "This attribute specifies whether to collect statistics data about the activity of auto-defined cluster-sender channels.", category = "Statistics monitoring")
	private WmqAutoCLUSSDRStatistics autoClussdrStatistics;

	@ConfigurationItemProperty(label = "Statistics Interval", identifying = true, description = "Type the interval, in seconds, between writing the statistics monitoring data to the monitoring queue. The default value is 1800 seconds.", category = "Statistics monitoring")
	private int statisticsInterval;

	@ConfigurationItemProperty(label = "MQI accounting", identifying = true, description = "To collect MQI accounting data for the queue manager.", category = "Accounting monitoring")
	private WmqMQIAccounting mqiAccounting;

	@ConfigurationItemProperty(label = "Queue accounting", identifying = true, description = "This attribute specifies whether to collect accounting data about the activity of connections for queues hosted by the queue manager.", category = "Accounting monitoring")
	private WmqQueueAccountingQManager queueAccounting;

	@ConfigurationItemProperty(label = "Accounting interval ", identifying = true, description = "Type the interval, in seconds, between writing the accounting monitoring data to the monitoring queue. The default value is 1800 seconds .", category = "Accounting monitoring")
	private int accountingInterval;

	@ConfigurationItemProperty(label = "Accounting conn override ", identifying = true, description = "Applications can override the MQI accounting attribute and the Queue accounting attribute using the Connect options in MQCONNX calls.", category = "Accounting monitoring")
	private WmqAccountingConnOverride accountingConnOverride;

	@ConfigurationItemProperty(label = "Publish/Subscribe mode ", identifying = true, description = "The Publish/Subscribe mode is used to allow coexistence with Publish/Subscribe engines in WebSphere MQ V6, WebSphere MB V6, and WebSphere EB V6.", category = "Publish/Subscribe")
	private WmqPublishSubscribeMode publishSubscribeMode;

	@ConfigurationItemProperty(label = "Publish/Subscribe syncpoint ", identifying = true, description = "This option defines whether messages will be processed under syncpoint.", category = "Publish/Subscribe")
	private WmqPublishSubscribeSyncPoint publishSubscribeSyncPoint;

	@ConfigurationItemProperty(label = "Undelivered non-persistent input message ", identifying = true, description = "This property defines what the Pub/Sub engine should do with non-persistent input messages that are not delivered.", category = "Publish/Subscribe")
	private WmqUndeliveredNonPersistentInputMessage undeliveredNonPersistentInputMessage;

	@ConfigurationItemProperty(label = "Undelivered non-persistent response ", identifying = true, description = "This property defines what the Pub/Sub engine should do with non-persistent responses that are not delivered.", category = "Publish/Subscribe")
	private WmqUndeliveredNonPersistentResponse undeliveredNonPersistentResponse;

	@ConfigurationItemProperty(label = "Tree lifetime ", identifying = true, description = "When this non-administrative node no longer has any active subscriptions, this parameter determines how long the queue manager will wait before removing that node,range from range 0 through 604 000.", category = "Publish/Subscribe")
	private int treeLifeTime;

	@ConfigurationItemProperty(label = "Parent ", identifying = true, description = "The name of the parent queue manager to which the local queue manager is to connect as its child in a hierarchy. If the field is left empty, then the queue manager has no parent queue manager, and if there is an existing parent queue manager it is disconnected.", category = "Publish/Subscribe")
	private String parent;

	public String getClusterName() {
		return clusterName;
	}

	public void setClusterName(String clusterName) {
		this.clusterName = clusterName;
	}

	public int getSyncpoint() {
		return syncpoint;
	}

	public void setSyncpoint(int syncpoint) {
		this.syncpoint = syncpoint;
	}

	public String getQueueManagerName() {
		return queueManagerName;
	}

	public void setQueueManagerName(String queueManagerName) {
		this.queueManagerName = queueManagerName;
	}

	public int getPlatform() {
		return platform;
	}

	public void setPlatform(int platform) {
		this.platform = platform;
	}

	public int getCodedCharacterSetIdentifier() {
		return codedCharacterSetIdentifier;
	}

	public void setCodedCharacterSetIdentifier(int codedCharacterSetIdentifier) {
		this.codedCharacterSetIdentifier = codedCharacterSetIdentifier;
	}

	public int getCommandLevel() {
		return commandLevel;
	}

	public void setCommandLevel(int commandLevel) {
		this.commandLevel = commandLevel;
	}

	public WmqCommandServerControl getCommandServerControl() {
		return commandServerControl;
	}

	public void setCommandServerControl(WmqCommandServerControl commandServerControl) {
		this.commandServerControl = commandServerControl;
	}

	public WmqChannelInitControl getChannelInitControl() {
		return channelInitControl;
	}

	public void setChannelInitControl(WmqChannelInitControl channelInitControl) {
		this.channelInitControl = channelInitControl;
	}

	public String getDeadLetterQueue() {
		return deadLetterQueue;
	}

	public void setDeadLetterQueue(String deadLetterQueue) {
		this.deadLetterQueue = deadLetterQueue;
	}

	public int getTriggerInterval() {
		return triggerInterval;
	}

	public void setTriggerInterval(int triggerInterval) {
		this.triggerInterval = triggerInterval;
	}

	public int getMaxUnCommittedMessages() {
		return maxUnCommittedMessages;
	}

	public void setMaxUnCommittedMessages(int maxUnCommittedMessages) {
		this.maxUnCommittedMessages = maxUnCommittedMessages;
	}

	public int getMaxHandles() {
		return maxHandles;
	}

	public void setMaxHandles(int maxHandles) {
		this.maxHandles = maxHandles;
	}

	public int getMaxMessageLength() {
		return maxMessageLength;
	}

	public void setMaxMessageLength(int maxMessageLength) {
		this.maxMessageLength = maxMessageLength;
	}

	public int getMessageMarkBrowseInterval() {
		return messageMarkBrowseInterval;
	}

	public void setMessageMarkBrowseInterval(int messageMarkBrowseInterval) {
		this.messageMarkBrowseInterval = messageMarkBrowseInterval;
	}

	public int getMaxPropertiesLength() {
		return maxPropertiesLength;
	}

	public void setMaxPropertiesLength(int maxPropertiesLength) {
		this.maxPropertiesLength = maxPropertiesLength;
	}

	public int getMaxPriority() {
		return maxPriority;
	}

	public void setMaxPriority(int maxPriority) {
		this.maxPriority = maxPriority;
	}

	public String getCommandInputQueue() {
		return commandInputQueue;
	}

	public void setCommandInputQueue(String commandInputQueue) {
		this.commandInputQueue = commandInputQueue;
	}

	public int getDistributionLists() {
		return distributionLists;
	}

	public void setDistributionLists(int distributionLists) {
		this.distributionLists = distributionLists;
	}

	public String getClusterWorkLoadExit() {
		return clusterWorkLoadExit;
	}

	public void setClusterWorkLoadExit(String clusterWorkLoadExit) {
		this.clusterWorkLoadExit = clusterWorkLoadExit;
	}

	public String getClusterWorkloadData() {
		return clusterWorkloadData;
	}

	public void setClusterWorkloadData(String clusterWorkloadData) {
		this.clusterWorkloadData = clusterWorkloadData;
	}

	public int getClusterWorkloadLength() {
		return clusterWorkloadLength;
	}

	public void setClusterWorkloadLength(int clusterWorkloadLength) {
		this.clusterWorkloadLength = clusterWorkloadLength;
	}

	public int getMaxOutBoundClusterChannels() {
		return maxOutBoundClusterChannels;
	}

	public void setMaxOutBoundClusterChannels(int maxOutBoundClusterChannels) {
		this.maxOutBoundClusterChannels = maxOutBoundClusterChannels;
	}

	public String getFullRepositoryForaCluster() {
		return fullRepositoryForaCluster;
	}

	public void setFullRepositoryForaCluster(String fullRepositoryForaCluster) {
		this.fullRepositoryForaCluster = fullRepositoryForaCluster;
	}

	public String getFullRepositoryForListOfClusters() {
		return fullRepositoryForListOfClusters;
	}

	public void setFullRepositoryForListOfClusters(String fullRepositoryForListOfClusters) {
		this.fullRepositoryForListOfClusters = fullRepositoryForListOfClusters;
	}

	public String getDefaultTransmissionQueue() {
		return defaultTransmissionQueue;
	}

	public void setDefaultTransmissionQueue(String defaultTransmissionQueue) {
		this.defaultTransmissionQueue = defaultTransmissionQueue;
	}

	public WmqChannelAutoDefinition getChannelAutoDefinition() {
		return channelAutoDefinition;
	}

	public void setChannelAutoDefinition(WmqChannelAutoDefinition channelAutoDefinition) {
		this.channelAutoDefinition = channelAutoDefinition;
	}

	public String getChannelAutoDefinitionExit() {
		return channelAutoDefinitionExit;
	}

	public void setChannelAutoDefinitionExit(String channelAutoDefinitionExit) {
		this.channelAutoDefinitionExit = channelAutoDefinitionExit;
	}

	public WmqActivityRecording getActivityRecording() {
		return activityRecording;
	}

	public void setActivityRecording(WmqActivityRecording activityRecording) {
		this.activityRecording = activityRecording;
	}

	public WmqTraceRouteRecording getTraceRouteRecording() {
		return traceRouteRecording;
	}

	public void setTraceRouteRecording(WmqTraceRouteRecording traceRouteRecording) {
		this.traceRouteRecording = traceRouteRecording;
	}

	public WmqAuthorityEvent getAuthorityEvent() {
		return authorityEvent;
	}

	public void setAuthorityEvent(WmqAuthorityEvent authorityEvent) {
		this.authorityEvent = authorityEvent;
	}

	public WmqInhibitEvents getInhibitEvents() {
		return inhibitEvents;
	}

	public void setInhibitEvents(WmqInhibitEvents inhibitEvents) {
		this.inhibitEvents = inhibitEvents;
	}

	public WmqLocalEvents getLocalEvents() {
		return localEvents;
	}

	public void setLocalEvents(WmqLocalEvents localEvents) {
		this.localEvents = localEvents;
	}

	public WmqRemoteEvents getRemoteEvents() {
		return remoteEvents;
	}

	public void setRemoteEvents(WmqRemoteEvents remoteEvents) {
		this.remoteEvents = remoteEvents;
	}

	public WmqStartAndStopEvents getStartAndStopEvents() {
		return startAndStopEvents;
	}

	public void setStartAndStopEvents(WmqStartAndStopEvents startAndStopEvents) {
		this.startAndStopEvents = startAndStopEvents;
	}

	public WmqPerformanceEvents getPerformanceEvents() {
		return performanceEvents;
	}

	public void setPerformanceEvents(WmqPerformanceEvents performanceEvents) {
		this.performanceEvents = performanceEvents;
	}

	public WmqChannelEvents getChannelEvents() {
		return channelEvents;
	}

	public void setChannelEvents(WmqChannelEvents channelEvents) {
		this.channelEvents = channelEvents;
	}

	public WmqChannelAutoDefinitionEvents getChannelAutoDefinitionEvents() {
		return channelAutoDefinitionEvents;
	}

	public void setChannelAutoDefinitionEvents(WmqChannelAutoDefinitionEvents channelAutoDefinitionEvents) {
		this.channelAutoDefinitionEvents = channelAutoDefinitionEvents;
	}

	public WmqSSLEvents getSslEvents() {
		return sslEvents;
	}

	public void setSslEvents(WmqSSLEvents sslEvents) {
		this.sslEvents = sslEvents;
	}

	public WmqLoggerEvents getLoggerEvents() {
		return loggerEvents;
	}

	public void setLoggerEvents(WmqLoggerEvents loggerEvents) {
		this.loggerEvents = loggerEvents;
	}

	public String getRevocationNameList() {
		return revocationNameList;
	}

	public void setRevocationNameList(String revocationNameList) {
		this.revocationNameList = revocationNameList;
	}

	public String getCryptographicHardware() {
		return cryptographicHardware;
	}

	public void setCryptographicHardware(String cryptographicHardware) {
		this.cryptographicHardware = cryptographicHardware;
	}

	public String getKeyRepository() {
		return keyRepository;
	}

	public WmqSslFipsRequired getSslFipsRequired() {
		return sslFipsRequired;
	}

	public void setSslFipsRequired(WmqSslFipsRequired sslFipsRequired) {
		this.sslFipsRequired = sslFipsRequired;
	}

	public void setKeyRepository(String keyRepository) {
		this.keyRepository = keyRepository;
	}

	public int getSslResetCount() {
		return sslResetCount;
	}

	public void setSslResetCount(int sslResetCount) {
		this.sslResetCount = sslResetCount;
	}

	public String getAlterationDate() {
		return alterationDate;
	}

	public void setAlterationDate(String alterationDate) {
		this.alterationDate = alterationDate;
	}

	public String getAlterationTime() {
		return alterationTime;
	}

	public void setAlterationTime(String alterationTime) {
		this.alterationTime = alterationTime;
	}

	public String getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(String creationDate) {
		this.creationDate = creationDate;
	}

	public String getCreationTime() {
		return creationTime;
	}

	public void setCreationTime(String creationTime) {
		this.creationTime = creationTime;
	}

	public WmqChannelMonitoringQManager getChannelMonitoring() {
		return channelMonitoring;
	}

	public void setChannelMonitoring(WmqChannelMonitoringQManager channelMonitoring) {
		this.channelMonitoring = channelMonitoring;
	}

	public WmqQueueMonitoringQManager getQueueMonitoring() {
		return queueMonitoring;
	}

	public void setQueueMonitoring(WmqQueueMonitoringQManager queueMonitoring) {
		this.queueMonitoring = queueMonitoring;
	}

	public WmqQueueStatisticsQManager getQueueStatistics() {
		return queueStatistics;
	}

	public void setQueueStatistics(WmqQueueStatisticsQManager queueStatistics) {
		this.queueStatistics = queueStatistics;
	}

	public WmqChannelStatisticTypesQManager getChannelStatistics() {
		return channelStatistics;
	}

	public void setChannelStatistics(WmqChannelStatisticTypesQManager channelStatistics) {
		this.channelStatistics = channelStatistics;
	}

	public int getStatisticsInterval() {
		return statisticsInterval;
	}

	public void setStatisticsInterval(int statisticsInterval) {
		this.statisticsInterval = statisticsInterval;
	}

	public WmqQueueAccountingQManager getQueueAccounting() {
		return queueAccounting;
	}

	public void setQueueAccounting(WmqQueueAccountingQManager queueAccounting) {
		this.queueAccounting = queueAccounting;
	}

	public int getAccountingInterval() {
		return accountingInterval;
	}

	public void setAccountingInterval(int accountingInterval) {
		this.accountingInterval = accountingInterval;
	}

	public WmqAccountingConnOverride getAccountingConnOverride() {
		return accountingConnOverride;
	}

	public void setAccountingConnOverride(WmqAccountingConnOverride accountingConnOverride) {
		this.accountingConnOverride = accountingConnOverride;
	}

	public WmqUndeliveredNonPersistentInputMessage getUndeliveredNonPersistentInputMessage() {
		return undeliveredNonPersistentInputMessage;
	}

	public void setUndeliveredNonPersistentInputMessage(WmqUndeliveredNonPersistentInputMessage undeliveredNonPersistentInputMessage) {
		this.undeliveredNonPersistentInputMessage = undeliveredNonPersistentInputMessage;
	}

	public WmqUndeliveredNonPersistentResponse getUndeliveredNonPersistentResponse() {
		return undeliveredNonPersistentResponse;
	}

	public void setUndeliveredNonPersistentResponse(WmqUndeliveredNonPersistentResponse undeliveredNonPersistentResponse) {
		this.undeliveredNonPersistentResponse = undeliveredNonPersistentResponse;
	}

	public int getTreeLifeTime() {
		return treeLifeTime;
	}

	public void setTreeLifeTime(int treeLifeTime) {
		this.treeLifeTime = treeLifeTime;
	}

	public String getParent() {
		return parent;
	}

	public void setParent(String parent) {
		this.parent = parent;
	}

	public WmqCLWLUseQueueQManager getClwlUseQueue() {
		return clwlUseQueue;
	}

	public void setClwlUseQueue(WmqCLWLUseQueueQManager clwlUseQueue) {
		this.clwlUseQueue = clwlUseQueue;
	}

	public WmqIPAddressVersion getIpAddressVersion() {
		return ipAddressVersion;
	}

	public void setIpAddressVersion(WmqIPAddressVersion ipAddressVersion) {
		this.ipAddressVersion = ipAddressVersion;
	}

	public String getQmid() {
		return qmid;
	}

	public void setQmid(String qmid) {
		this.qmid = qmid;
	}

	public WmqAutoCLUSSDRMonitoring getAutoClussdrMonitoring() {
		return autoClussdrMonitoring;
	}

	public void setAutoClussdrMonitoring(WmqAutoCLUSSDRMonitoring autoClussdrMonitoring) {
		this.autoClussdrMonitoring = autoClussdrMonitoring;
	}

	public WmqMQIStatistics getMqiStatistics() {
		return mqiStatistics;
	}

	public void setMqiStatistics(WmqMQIStatistics mqiStatistics) {
		this.mqiStatistics = mqiStatistics;
	}

	public WmqAutoCLUSSDRStatistics getAutoClussdrStatistics() {
		return autoClussdrStatistics;
	}

	public void setAutoClussdrStatistics(WmqAutoCLUSSDRStatistics autoClussdrStatistics) {
		this.autoClussdrStatistics = autoClussdrStatistics;
	}

	public WmqMQIAccounting getMqiAccounting() {
		return mqiAccounting;
	}

	public void setMqiAccounting(WmqMQIAccounting mqiAccounting) {
		this.mqiAccounting = mqiAccounting;
	}

	public WmqPublishSubscribeMode getPublishSubscribeMode() {
		return publishSubscribeMode;
	}

	public void setPublishSubscribeMode(WmqPublishSubscribeMode publishSubscribeMode) {
		this.publishSubscribeMode = publishSubscribeMode;
	}

	public WmqPublishSubscribeSyncPoint getPublishSubscribeSyncPoint() {
		return publishSubscribeSyncPoint;
	}

	public void setPublishSubscribeSyncPoint(WmqPublishSubscribeSyncPoint publishSubscribeSyncPoint) {
		this.publishSubscribeSyncPoint = publishSubscribeSyncPoint;
	}

	public String getQManagerDescription() {
		return qManagerDescription;
	}

	public void setQManagerDescription(String qManagerDescription) {
		this.qManagerDescription = qManagerDescription;
	}

}
