/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wmq.enums.WmqWildcardOperation;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDurableSubscriptions;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonPersistentMessageDelivery;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPersistentMessageDelivery;
import com.xebialabs.deployit.plugin.wmq.enums.WmqProxySubscriptionBehavior;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPublicationScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSubscriptionScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTopicDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTopicDefaultPutResponseType;
import com.xebialabs.deployit.plugin.wmq.utils.WMQConstants;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "An MQ topic is an MQ object that identifies what a publication is about.")
public class WmqTopic extends BaseConfigurationItem implements WmqResource {

	@ConfigurationItemProperty(required = true, label = "Topic name", identifying = true, description = "This value cannot be changed once the topic has been created. This parameter is required and cannot contain an empty string.")
	private String topicName;

	@ConfigurationItemProperty(required = true, label = "Topic String", description = "This value cannot be changed once the topic has been created. This parameter is required and cannot contain an empty string.Topic String must not be the same as any other topic string already represented by another topic object definition. The maximum length of a topic string is 10 240 characters.")
	private String topicString;

	@ConfigurationItemProperty(required = false, label = "Topic Description", description = "This value is a string entered by the administrator. It contains descriptive information about the topic. It must contain only displayable characters. A maximum of 64 characters.")
	private String description;

	@ConfigurationItemProperty(required = false, label = "Durable subscriptions", description = "This property controls whether the topic permits durable subscriptions to be made. The default value is As parent.")
	private WmqDurableSubscriptions durablesubScriptions;

	@ConfigurationItemProperty(required = false, label = "Default priority ", description = "The default priority of messages published to the topic. An integer in the range 0-9. The default value is As parent.")
	private int defaultPriority = WMQConstants.INTEGER_MAX_VALUE_SUPPORTED;

	@ConfigurationItemProperty(required = false, label = "Default persistence ", description = "The default persistence of a new topic is As parent. Select Persistent to specify that messages created by applications that use MQPER_PERSISTENCE_AS_Q_DEF become persistent.")
	private WmqTopicDefaultPersistence defaultPersistence;

	@ConfigurationItemProperty(required = false, label = "Model durable queue", description = "This value is a string entered by the administrator. It contains the name of the model queue used for durable subscriptions which request that the queue manager manage the destination of the publication.")
	private String modelDurableQueue;

	@ConfigurationItemProperty(required = false, label = "Model non-durable queue ", description = "This value is a string entered by the administrator. It contains the name of the model queue used for non-durable subscriptions which request that the queue manager manage the destination of the publication.")
	private String modelNonDurableQueue;

	@ConfigurationItemProperty(required = false, label = "Default put response Type ", description = "The default put response is based on the setting of the closest parent administrative topic object in the topic tree.")
	private WmqTopicDefaultPutResponseType defaultPutResponseType;

	@ConfigurationItemProperty(required = false, label = "Non Persistent Message Delivery ", description = "The delivery mechanism for non-persistent messages published to this topic.")
	private WmqNonPersistentMessageDelivery nonPersistentMessageDelivery;

	@ConfigurationItemProperty(required = false, label = "Persistent Message Delivery ", description = "The delivery mechanism for persistent messages published to this topic.")
	private WmqPersistentMessageDelivery persistentMessageDelivery;

	@ConfigurationItemProperty(required = false, label = "Wildcard Operation", description = "Behavior of subscriptions including wildcards made to this topic .")
	private WmqWildcardOperation wildcardOperation;

	@ConfigurationItemProperty(required = false, label = "QProxy subscription behavior ", description = "Proxy-subscriptions are associated with the queue manager name that created them. Publications are only forwarded to directly connected queue managers if a proxy-subscription exists that includes the publication topic.", category = "Distributed Publish/Subscribe")
	private WmqProxySubscriptionBehavior proxySubscriptionBehavior;

	@ConfigurationItemProperty(required = false, label = "Publication scope ", description = "The scope of publications can be controlled administratively using the PUBSCOPE topic attribute.", category = "Distributed Publish/Subscribe")
	private WmqPublicationScope publicationScope;

	@ConfigurationItemProperty(required = false, label = "Subscription scope ", description = "The scope of subscriptions can be controlled administratively using the SUBSCOPE topic attribute.", category = "Distributed Publish/Subscribe")
	private WmqSubscriptionScope subscriptionScope;

	@ConfigurationItemProperty(required = false, label = "Cluster name", description = "This is the name of the cluster that the topic publishes to. When a cluster topic is defined, the cluster topic object is published to the full repositories.", category = "Cluster")
	private String clusterName;

	public WmqTopicDefaultPutResponseType getDefaultPutResponseType() {
		return defaultPutResponseType;
	}

	public void setDefaultPutResponseType(WmqTopicDefaultPutResponseType defaultPutResponseType) {
		this.defaultPutResponseType = defaultPutResponseType;
	}

	public WmqNonPersistentMessageDelivery getNonPersistentMessageDelivery() {
		return nonPersistentMessageDelivery;
	}

	public void setNonPersistentMessageDelivery(WmqNonPersistentMessageDelivery nonPersistentMessageDelivery) {
		this.nonPersistentMessageDelivery = nonPersistentMessageDelivery;
	}

	public WmqPersistentMessageDelivery getPersistentMessageDelivery() {
		return persistentMessageDelivery;
	}

	public void setPersistentMessageDelivery(WmqPersistentMessageDelivery persistentMessageDelivery) {
		this.persistentMessageDelivery = persistentMessageDelivery;
	}

	public WmqWildcardOperation getWildcardOperation() {
		return wildcardOperation;
	}

	public void setWildcardOperation(WmqWildcardOperation wildcardOperation) {
		this.wildcardOperation = wildcardOperation;
	}

	public String getTopicName() {
		return topicName;
	}

	public void setTopicName(String topicName) {
		this.topicName = topicName;
	}

	public String getTopicString() {
		return topicString;
	}

	public void setTopicString(String topicString) {
		this.topicString = topicString;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public WmqDurableSubscriptions getDurablesubScriptions() {
		return durablesubScriptions;
	}

	public void setDurablesubScriptions(WmqDurableSubscriptions durablesubScriptions) {
		this.durablesubScriptions = durablesubScriptions;
	}

	public int getDefaultPriority() {
		return defaultPriority;
	}

	public void setDefaultPriority(int defaultPriority) {
		this.defaultPriority = defaultPriority;
	}

	public WmqTopicDefaultPersistence getDefaultPersistence() {
		return defaultPersistence;
	}

	public void setDefaultPersistence(WmqTopicDefaultPersistence defaultPersistence) {
		this.defaultPersistence = defaultPersistence;
	}

	public String getModelDurableQueue() {
		return modelDurableQueue;
	}

	public void setModelDurableQueue(String modelDurableQueue) {
		this.modelDurableQueue = modelDurableQueue;
	}

	public String getModelNonDurableQueue() {
		return modelNonDurableQueue;
	}

	public void setModelNonDurableQueue(String modelNonDurableQueue) {
		this.modelNonDurableQueue = modelNonDurableQueue;
	}

	public WmqProxySubscriptionBehavior getProxySubscriptionBehavior() {
		return proxySubscriptionBehavior;
	}

	public void setProxySubscriptionBehavior(WmqProxySubscriptionBehavior proxySubscriptionBehavior) {
		this.proxySubscriptionBehavior = proxySubscriptionBehavior;
	}

	public WmqPublicationScope getPublicationScope() {
		return publicationScope;
	}

	public void setPublicationScope(WmqPublicationScope publicationScope) {
		this.publicationScope = publicationScope;
	}

	public WmqSubscriptionScope getSubscriptionScope() {
		return subscriptionScope;
	}

	public void setSubscriptionScope(WmqSubscriptionScope subscriptionScope) {
		this.subscriptionScope = subscriptionScope;
	}

	public String getClusterName() {
		return clusterName;
	}

	public void setClusterName(String clusterName) {
		this.clusterName = clusterName;
	}

}
