/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqSenderChannel;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMCAType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDataConversion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqSenderChannel} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqSenderChannelStep extends BaseWmqStep {

	public WmqSenderChannel wmqSenderChannel;

	public CreateWmqSenderChannelStep(WmqSenderChannel wmqSenderChannel, WmqQueueManager wmqQmanager)

	{

		this.wmqSenderChannel = wmqSenderChannel;
		this.wmqQmanager = wmqQmanager;

	}

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_CREATE_CHANNEL;

	}

	@Override
	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// Setting MQ SenderChannelName
		pcfCmd.addParameter(MQConstants.MQCACH_CHANNEL_NAME, wmqSenderChannel.getChannelName());

		// Setting MQ SenderChannelType
		pcfCmd.addParameter(MQConstants.MQIACH_CHANNEL_TYPE, MQConstants.MQCHT_SENDER);

		// Setting MQ SenderChannel Description
		if (StringUtils.isNotBlank(wmqSenderChannel.getDescription())) {

			pcfCmd.addParameter(MQConstants.MQCACH_DESC, wmqSenderChannel.getDescription());
		}

		// Setting MQ SenderChannel Transport Type
		if (WmqTransmissionProtocolTypes.LU6 == wmqSenderChannel.getTransportType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_LU62);

		} else if (WmqTransmissionProtocolTypes.NET_BIOS == wmqSenderChannel.getTransportType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_NETBIOS);

		} else if (WmqTransmissionProtocolTypes.SPX == wmqSenderChannel.getTransportType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_SPX);
		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_TCP);
		}

		// Setting MQ SenderChannel Connection name
		if (StringUtils.isNotBlank(wmqSenderChannel.getConnectionName())) {

			pcfCmd.addParameter(MQConstants.MQCACH_CONNECTION_NAME, wmqSenderChannel.getConnectionName());
		}

		// Setting MQ SenderChannel TransmissinQueue
		pcfCmd.addParameter(MQConstants.MQCACH_XMIT_Q_NAME, wmqSenderChannel.getTransmissionQueue());

		// Setting MQ SenderChannel Local communications address
		if (StringUtils.isNotBlank(wmqSenderChannel.getLocalCommunicationAddress())) {

			pcfCmd.addParameter(MQConstants.MQCACH_LOCAL_ADDRESS, wmqSenderChannel.getLocalCommunicationAddress());
		}

		// Setting MQ SenderChannel HeaderCompression value
		if (WmqHeaderCompression.SYSTEM == wmqSenderChannel.getHeaderCompression()) {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_SYSTEM;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		} else {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_NONE;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		}

		// Setting MQ SenderChannel KeepaliveInterval
		if (wmqSenderChannel.getKeepAliveInterval() > -1 && wmqSenderChannel.getKeepAliveInterval() <= 99999) {
			pcfCmd.addParameter(MQConstants.MQIACH_KEEP_ALIVE_INTERVAL, wmqSenderChannel.getKeepAliveInterval());
		}

		// Setting MQ SenderChannel HeartbeatInterval
		pcfCmd.addParameter(MQConstants.MQIACH_HB_INTERVAL, wmqSenderChannel.getHeartBeatInterval());

		// Setting MQ SenderChannel MaximumMessageLength
		pcfCmd.addParameter(MQConstants.MQIACH_MAX_MSG_LENGTH, wmqSenderChannel.getMaximumMessageLength());

		// Setting MQ SenderChannel maximum message sequence number
		if (wmqSenderChannel.getSequenceNumberWrap() < 100) {
			pcfCmd.addParameter(MQConstants.MQIACH_SEQUENCE_NUMBER_WRAP, 999999999);
		} else if (wmqSenderChannel.getSequenceNumberWrap() != 0) {

			pcfCmd.addParameter(MQConstants.MQIACH_SEQUENCE_NUMBER_WRAP, wmqSenderChannel.getSequenceNumberWrap());
		}

		int[] messageCompressionList = new int[1];
		// Setting MQ SenderChannel MessageCompression Value
		if (WmqMessageCompression.RLE == wmqSenderChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_RLE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqMessageCompression.ZLIBFAST == wmqSenderChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBFAST;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqMessageCompression.ZLIBHIGH == wmqSenderChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBHIGH;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		} else {
			messageCompressionList[0] = MQConstants.MQCOMPRESS_NONE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		}

		// Setting MQ SenderChannel NonPersistentMessageSpeed
		if (WmqNonpersistentMessageSpeed.NORMAL == wmqSenderChannel.getNonPersistentMessageSpeed()) {

			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_NORMAL);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_FAST);
		}

		// Setting MQ SenderChannel BatchSize
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_SIZE, wmqSenderChannel.getBatchSize());

		// Setting MQ SenderChannel BatchInterval
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_INTERVAL, wmqSenderChannel.getBatchInterval());

		// Setting MQ SenderChannel DisconnectInterval
		pcfCmd.addParameter(MQConstants.MQIACH_DISC_INTERVAL, wmqSenderChannel.getDisconnectInterval());

		// Setting MQ SenderChannel DataConversion value
		if (WmqDataConversion.CONVERSION == wmqSenderChannel.getDataConversion()) {

			pcfCmd.addParameter(MQConstants.MQIACH_DATA_CONVERSION, MQConstants.MQCDC_SENDER_CONVERSION);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_DATA_CONVERSION, MQConstants.MQCDC_NO_SENDER_CONVERSION);
		}

		// Setting MQ SenderChannel BatchHeartBeatInterval
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_HB, wmqSenderChannel.getBatchHeartBeatInterval());

		if (wmqQmanager.getVersion() != WmqVersion.WMQ_60) {

			// Setting MQ SenderChannel PropertyControl
			if (WmqChannelPropertyControl.ALL == wmqSenderChannel.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_ALL);

			} else if (WmqChannelPropertyControl.NONE == wmqSenderChannel.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_NONE);

			} else {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_COMPATIBILITY);
			}
		}

		// Setting MQ SenderChannel MCAUserID
		if (StringUtils.isNotBlank(wmqSenderChannel.getMcaUserID())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MCA_USER_ID, wmqSenderChannel.getMcaUserID());

		}

		// Setting MQ SenderChannel MCAType
		if (WmqChannelMCAType.THREAD == wmqSenderChannel.getMcaType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_MCA_TYPE, MQConstants.MQMCAT_THREAD);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_MCA_TYPE, MQConstants.MQMCAT_PROCESS);
		}

		// Setting MQ SenderChannel SendExitname
		if (StringUtils.isNotBlank(wmqSenderChannel.getSendExit())) {

			String[] sendExitList = StringUtils.split(wmqSenderChannel.getSendExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_NAME, sendExitList);

		}

		// Setting MQ SenderChannel SendUserData
		if (StringUtils.isNotBlank(wmqSenderChannel.getSendExitUserData())) {

			String[] sendExitUserDataList = StringUtils.split(wmqSenderChannel.getSendExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_USER_DATA, sendExitUserDataList);
		}

		// Setting MQ SenderChannel ReceiveExit
		if (StringUtils.isNotBlank(wmqSenderChannel.getReceiveExit())) {

			String[] receiveExitList = StringUtils.split(wmqSenderChannel.getReceiveExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_NAME, receiveExitList);
		}

		// Setting MQ SenderChannel ReceiveUserData
		if (StringUtils.isNotBlank(wmqSenderChannel.getReceiveExitUserData())) {

			String[] receiveExitUserDataList = StringUtils.split(wmqSenderChannel.getReceiveExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_USER_DATA, receiveExitUserDataList);
		}

		// Setting MQ SenderChannel SecurityExit
		if (StringUtils.isNotBlank(wmqSenderChannel.getSecurityExit())) {
			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_NAME, wmqSenderChannel.getSecurityExit());
		}

		// Setting MQ SenderChannel SecurityUserData
		if (StringUtils.isNotBlank(wmqSenderChannel.getSecurityExitUserData())) {

			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_USER_DATA, wmqSenderChannel.getSecurityExitUserData());
		}

		// Setting MQ SenderChannel MsgExit
		if (StringUtils.isNotBlank(wmqSenderChannel.getMessageExitName())) {

			String[] messageExitList = StringUtils.split(wmqSenderChannel.getMessageExitName(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_NAME, messageExitList);
		}

		// Setting MQ SenderChannel MsgUserData
		if (StringUtils.isNotBlank(wmqSenderChannel.getMessageExitUserData())) {

			String[] messageExitUserList = StringUtils.split(wmqSenderChannel.getMessageExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_USER_DATA, messageExitUserList);
		}

		// Setting MQ SenderChannel ShortRetryCount
		pcfCmd.addParameter(MQConstants.MQIACH_SHORT_RETRY, wmqSenderChannel.getShortRetryCount());

		// Setting MQ SenderChannel ShortRetryInterval
		pcfCmd.addParameter(MQConstants.MQIACH_SHORT_TIMER, wmqSenderChannel.getShortRetryInterval());

		// Setting MQ SenderChannel LongRetryCount
		pcfCmd.addParameter(MQConstants.MQIACH_LONG_RETRY, wmqSenderChannel.getLongRetryCount());

		// Setting MQ SenderChannel LongRetryInterval
		pcfCmd.addParameter(MQConstants.MQIACH_LONG_TIMER, wmqSenderChannel.getLongRetryInterval());

		// Setting MQ SenderChannel Monitoring
		if (WmqChannelMonitoring.HIGH == wmqSenderChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelMonitoring.LOW == wmqSenderChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelMonitoring.MEDIUM == wmqSenderChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelMonitoring.OFF == wmqSenderChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ SenderChannel Statistics
		if (WmqChannelStatisticTypes.HIGH == wmqSenderChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelStatisticTypes.LOW == wmqSenderChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelStatisticTypes.MEDIUM == wmqSenderChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelStatisticTypes.OFF == wmqSenderChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ SenderChannel SSLCipherSpec
		if (wmqSenderChannel.getSslCipherSpecification() != null) {

			pcfCmd.addParameter(MQConstants.MQCACH_SSL_CIPHER_SPEC, wmqSenderChannel.getSslCipherSpecification().toString());
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating SenderChannel \"" + wmqSenderChannel.getChannelName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Creating SenderChannel Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The SenderChannel \"" + wmqSenderChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";

	}
}
