/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.utils.RegexUtils;

/**
 * Retrieves the version of the MQSeries from the host.
 */
@SuppressWarnings("serial")
public class RetrieveWmqVersionStep implements Step {

	private WmqQueueManager wmqQueueManager;

	public RetrieveWmqVersionStep(WmqQueueManager wmqQueueManager) {
		this.wmqQueueManager = wmqQueueManager;
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession hostSession = wmqQueueManager.getHostName().getHostSession();
		try {
			CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
			int res = hostSession.execute(capturedOutput, "dspmqver");
			if (res != 0) {
				ctx.logError("Non-zero exitcode from dspmqver: " + res);
				return false;
			}
			for (String eachLine : capturedOutput.getOutputLines()) {
				if (eachLine.startsWith("Version")) {
					String[] matches = RegexUtils.regexMatch(eachLine, "Version:\\s+(\\d+)\\.(\\d+)\\.[\\d\\.]*");
					if (matches != null && matches.length == 2) {
						int majorVersion = Integer.parseInt(matches[0]);
						if (majorVersion == 6) {
							wmqQueueManager.setVersion(WmqVersion.WMQ_60);
							ctx.logOutput("Installation of MQ Series on the Host \t " + wmqQueueManager.getHostName() + "  \t is " + majorVersion);
							return true;
						} else if (majorVersion == 7) {
							ctx.logOutput("Installation of MQ Series on the Host \t " + wmqQueueManager.getHostName() + " \t is " + majorVersion);
							wmqQueueManager.setVersion(WmqVersion.WMQ_70);
							return true;
						}
					}
				}
			}
			ctx.logError("Could not determine installed version of MQ Series ");
			return false;
		} finally {
			hostSession.close();
		}
	}

	public String getDescription() {

		return "Retrieving the Version of WebSphereMQ on the Host \t " + wmqQueueManager.getHostName();
	}
}