/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;
import com.xebialabs.deployit.plugin.wmq.utils.PCF_CommonMethods;
import com.xebialabs.deployit.plugin.wmq.utils.WmqHelper;

public abstract class BaseWmqStep
implements Step {
    protected WmqQueueManager wmqQmanager;
    protected int mqCommand;

    public boolean execute(StepExecutionContext ctx) {
        this.init();
        PCF_CommonMethods pcfCM = new PCF_CommonMethods();
        try {
            WmqHelper.createAgent(this.wmqQmanager, pcfCM, ctx);
            PCFMessage pcfCmd = new PCFMessage(this.mqCommand);
            this.setPCFMessageParameters(pcfCmd);
            PCFMessage pcfMessage = WmqHelper.sendPcfcmCommand(pcfCM, pcfCmd);
            this.readPCFMessageResponse(ctx, pcfMessage);
            pcfCM.destroyAgent();
        }
        catch (Exception e) {
            pcfCM.displayException(e, ctx);
            return false;
        }
        return true;
    }

    protected void readPCFMessageResponse(StepExecutionContext ctx, PCFMessage pcfMessage) {
        if (pcfMessage.getReason() == 0) {
            ctx.logOutput("Operation Successfull");
            ctx.logOutput(this.getSuccessMessage());
        }
    }

    protected abstract String getSuccessMessage();

    protected abstract void init();

    public abstract void setPCFMessageParameters(PCFMessage var1) throws MQPluginException;

    public String getDescription() {
        return null;
    }
}

