/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.RegexUtils;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class CheckWmqQueueManagerNameStep
implements Step {
    private WmqQueueManager wmqQueueManager;

    public CheckWmqQueueManagerNameStep(WmqQueueManager wmqQueueManager) {
        this.wmqQueueManager = wmqQueueManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.wmqQueueManager.getHostName().getHostSession();
        ArrayList<String> list = new ArrayList<String>();
        try {
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("dspmq");
            Object[] cmdArray = cmd.toArray(new String[cmd.size()]);
            int res = hostSession.execute((CommandExecutionCallbackHandler)capturedOutput, (String[])cmdArray);
            if (res != 0) {
                ctx.logError("Non-zero exitcode from " + StringUtils.join((Object[])cmdArray, (String)" ") + ": " + res);
                boolean bl = false;
                return bl;
            }
            for (String eachLine : capturedOutput.getOutputLines()) {
                String[] matches;
                if (!eachLine.startsWith("QMNAME") || (matches = RegexUtils.regexMatch(eachLine, "QMNAME\\((\\S+)\\)[\\s\\S]*")) == null || matches.length != 1) continue;
                String wmqQManagerName = matches[0];
                if (wmqQManagerName.equalsIgnoreCase(this.wmqQueueManager.getQueueManagerName())) {
                    ctx.logOutput("Check QueueManager Name Step succeeded");
                    boolean bl = true;
                    return bl;
                }
                list.add(wmqQManagerName);
            }
        }
        finally {
            hostSession.close();
        }
        ctx.logError("Queue Manager Name \"" + this.wmqQueueManager.getQueueManagerName() + "\" is not available");
        if (list.size() > 0) {
            ctx.logOutput("Available Queue Manager Names on the Host \"" + this.wmqQueueManager.getHostName() + "\" " + list);
        }
        return false;
    }

    public String getDescription() {
        return "Check QueueManager Name Step";
    }
}

