/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqAliasQueue;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqBaseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultBindType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPutResponseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultReadAhead;
import com.xebialabs.deployit.plugin.wmq.enums.WmqGetMessages;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPutMessage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

public class CreateWmqAliasQueueStep
extends BaseWmqStep {
    public WmqAliasQueue wmqAliasQueue;

    protected void init() {
        this.mqCommand = 11;
    }

    public CreateWmqAliasQueueStep(WmqAliasQueue wmqAliasQueue, WmqQueueManager wmqQmanager) {
        this.wmqAliasQueue = wmqAliasQueue;
        this.wmqQmanager = wmqQmanager;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {
        pcfCmd.addParameter(2016, this.wmqAliasQueue.getQueueName());
        pcfCmd.addParameter(20, 3);
        pcfCmd.addParameter(2002, this.wmqAliasQueue.getBaseObject());
        if (this.wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
            if (WmqBaseType.QUEUE == this.wmqAliasQueue.getBaseType()) {
                pcfCmd.addParameter(193, 1);
            } else if (WmqBaseType.TOPIC == this.wmqAliasQueue.getBaseType()) {
                pcfCmd.addParameter(193, 8);
            }
            if (WmqDefaultPutResponseType.SYNCHRONOUS == this.wmqAliasQueue.getDefaultPutResponseType()) {
                pcfCmd.addParameter(184, 1);
            } else if (WmqDefaultPutResponseType.ASYNCHRONOUS == this.wmqAliasQueue.getDefaultPutResponseType()) {
                pcfCmd.addParameter(184, 2);
            }
            if (WmqDefaultReadAhead.YES == this.wmqAliasQueue.getDefaultReadAhead()) {
                pcfCmd.addParameter(188, 1);
            } else if (WmqDefaultReadAhead.NO == this.wmqAliasQueue.getDefaultReadAhead()) {
                pcfCmd.addParameter(188, 0);
            } else if (WmqDefaultReadAhead.DISABLED == this.wmqAliasQueue.getDefaultReadAhead()) {
                pcfCmd.addParameter(188, 2);
            }
            if (WmqPropertyControl.COMPATABILITY == this.wmqAliasQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 0);
            } else if (WmqPropertyControl.NONE == this.wmqAliasQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 1);
            } else if (WmqPropertyControl.ALL == this.wmqAliasQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 2);
            } else if (WmqPropertyControl.FORCE_MQ_RFH2 == this.wmqAliasQueue.getPropertyControl()) {
                pcfCmd.addParameter(190, 3);
            }
        }
        pcfCmd.addParameter(95, this.wmqAliasQueue.getClwlQueueRank());
        pcfCmd.addParameter(96, this.wmqAliasQueue.getClwlQueuePriority());
        if (WmqDefaultPersistence.PERSISTENT == this.wmqAliasQueue.getDefaultPersistence()) {
            pcfCmd.addParameter(5, 1);
        } else if (WmqDefaultPersistence.NOT_PERSISTENT == this.wmqAliasQueue.getDefaultPersistence()) {
            pcfCmd.addParameter(5, 0);
        }
        if (WmqPutMessage.ALLOWED == this.wmqAliasQueue.getPutMessages()) {
            pcfCmd.addParameter(10, 0);
        } else if (WmqPutMessage.INHIBITED == this.wmqAliasQueue.getPutMessages()) {
            pcfCmd.addParameter(10, 1);
        }
        if (StringUtils.isNotBlank(this.wmqAliasQueue.getDescription())) {
            pcfCmd.addParameter(2013, this.wmqAliasQueue.getDescription());
        }
        pcfCmd.addParameter(6, this.wmqAliasQueue.getDefaultPriority());
        if (WmqScope.QUEUE_MANAGER == this.wmqAliasQueue.getScope()) {
            pcfCmd.addParameter(45, 1);
        } else if (WmqScope.CELL == this.wmqAliasQueue.getScope()) {
            pcfCmd.addParameter(45, 2);
        }
        if (WmqDefaultBindType.ON_OPEN == this.wmqAliasQueue.getDefaultBindType()) {
            pcfCmd.addParameter(61, 0);
        } else if (WmqDefaultBindType.NOT_FIXED == this.wmqAliasQueue.getDefaultBindType()) {
            pcfCmd.addParameter(61, 1);
        }
        if (WmqGetMessages.ALLOWED == this.wmqAliasQueue.getGetMessages()) {
            pcfCmd.addParameter(9, 0);
        } else if (WmqGetMessages.INHIBITED == this.wmqAliasQueue.getGetMessages()) {
            pcfCmd.addParameter(9, 1);
        }
        if (this.wmqAliasQueue.getClusterName() != null && this.wmqAliasQueue.getClusterNamelist() != null) {
            throw new MQPluginException("Clustername and Cluster Namelist both should not be given at a time in CI");
        }
        if (StringUtils.isNotBlank(this.wmqAliasQueue.getClusterName())) {
            pcfCmd.addParameter(2029, this.wmqAliasQueue.getClusterName());
        }
        if (StringUtils.isNotBlank(this.wmqAliasQueue.getClusterNamelist())) {
            pcfCmd.addParameter(2030, this.wmqAliasQueue.getClusterNamelist());
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating AliasQueue \"" + this.wmqAliasQueue.getQueueName() + "\" on QueuManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating AliasQueue Step";
    }

    protected String getSuccessMessage() {
        return "The AliasQueue \"" + this.wmqAliasQueue.getQueueName() + "\" is created on QueueManager\"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

