/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqRemoteQueue;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultBindType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPutResponseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPutMessage;
import com.xebialabs.deployit.plugin.wmq.enums.WmqScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

public class CreateWmqRemoteQueueStep
extends BaseWmqStep {
    public WmqRemoteQueue wmqRemoteQueue;

    protected void init() {
        this.mqCommand = 11;
    }

    public CreateWmqRemoteQueueStep(WmqRemoteQueue wmqRemoteQueue, WmqQueueManager wmqQmanager) {
        this.wmqRemoteQueue = wmqRemoteQueue;
        this.wmqQmanager = wmqQmanager;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {
        pcfCmd.addParameter(2016, this.wmqRemoteQueue.getQueueName());
        pcfCmd.addParameter(20, 6);
        pcfCmd.addParameter(2018, this.wmqRemoteQueue.getRemoteQueue());
        pcfCmd.addParameter(2017, this.wmqRemoteQueue.getRemoteQueueManager());
        if (WmqDefaultPersistence.PERSISTENT == this.wmqRemoteQueue.getDefaultPersistence()) {
            pcfCmd.addParameter(5, 1);
        } else if (WmqDefaultPersistence.NOT_PERSISTENT == this.wmqRemoteQueue.getDefaultPersistence()) {
            pcfCmd.addParameter(5, 0);
        }
        if (WmqPutMessage.ALLOWED == this.wmqRemoteQueue.getPutMessages()) {
            pcfCmd.addParameter(10, 0);
        } else if (WmqPutMessage.INHIBITED == this.wmqRemoteQueue.getPutMessages()) {
            pcfCmd.addParameter(10, 1);
        }
        if (this.wmqRemoteQueue.getDescription() != null && !"".equals(this.wmqRemoteQueue.getDescription())) {
            pcfCmd.addParameter(2013, this.wmqRemoteQueue.getDescription());
        }
        pcfCmd.addParameter(6, this.wmqRemoteQueue.getDefaultPriority());
        if (WmqScope.QUEUE_MANAGER == this.wmqRemoteQueue.getScope()) {
            pcfCmd.addParameter(45, 1);
        } else if (WmqScope.CELL == this.wmqRemoteQueue.getScope()) {
            pcfCmd.addParameter(45, 2);
        }
        if (this.wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
            if (WmqDefaultPutResponseType.SYNCHRONOUS == this.wmqRemoteQueue.getDefaultPutResponseType()) {
                pcfCmd.addParameter(184, 1);
            } else if (WmqDefaultPutResponseType.ASYNCHRONOUS == this.wmqRemoteQueue.getDefaultPutResponseType()) {
                pcfCmd.addParameter(184, 2);
            }
        }
        if (this.wmqRemoteQueue.getTransmissionQueue() != null && !"".equals(this.wmqRemoteQueue.getTransmissionQueue())) {
            pcfCmd.addParameter(2024, this.wmqRemoteQueue.getTransmissionQueue());
        }
        if (WmqDefaultBindType.ON_OPEN == this.wmqRemoteQueue.getDefaultBindType()) {
            pcfCmd.addParameter(61, 0);
        } else if (WmqDefaultBindType.NOT_FIXED == this.wmqRemoteQueue.getDefaultBindType()) {
            pcfCmd.addParameter(61, 1);
        }
        if (this.wmqRemoteQueue.getClusterName() != null && this.wmqRemoteQueue.getClusterNamelist() != null) {
            throw new MQPluginException("Clustername and Cluster Namelist both should not be given at a time in CI");
        }
        if (StringUtils.isNotBlank(this.wmqRemoteQueue.getClusterName())) {
            pcfCmd.addParameter(2029, this.wmqRemoteQueue.getClusterName());
        }
        if (StringUtils.isNotBlank(this.wmqRemoteQueue.getClusterNamelist())) {
            pcfCmd.addParameter(2030, this.wmqRemoteQueue.getClusterNamelist());
        }
        pcfCmd.addParameter(95, this.wmqRemoteQueue.getClwlQueueRank());
        pcfCmd.addParameter(96, this.wmqRemoteQueue.getClwlQueueRank());
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating RemoteQueue \"" + this.wmqRemoteQueue.getQueueName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating RemoteQueue Step";
    }

    protected String getSuccessMessage() {
        return "The RemoteQueue \"" + this.wmqRemoteQueue.getQueueName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

