/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFException;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;
import com.xebialabs.deployit.plugin.wmq.utils.PCF_CommonMethods;
import com.xebialabs.deployit.plugin.wmq.utils.WmqHelper;

public class InquireWmqQueueManagerClusterStep
implements Step {
    protected WmqQueueManager wmqQmanager;
    protected int mqCommand;

    protected void init() {
        this.mqCommand = 70;
    }

    public InquireWmqQueueManagerClusterStep(WmqQueueManager wmqQmanager) {
        this.wmqQmanager = wmqQmanager;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {
        pcfCmd.addParameter(2031, this.wmqQmanager.getQueueManagerName());
    }

    public boolean execute(StepExecutionContext ctx) {
        this.init();
        PCF_CommonMethods pcfCM = new PCF_CommonMethods();
        try {
            WmqHelper.createAgent(this.wmqQmanager, pcfCM, ctx);
            PCFMessage pcfCmd = new PCFMessage(this.mqCommand);
            this.setPCFMessageParameters(pcfCmd);
            PCFMessage[] pcfResponse = WmqHelper.sendPcfcmCommandToAgent(pcfCM, pcfCmd);
            this.readPCFMessageResponse(ctx, pcfResponse);
            pcfCM.destroyAgent();
        }
        catch (Exception e) {
            if (e.getClass().equals(PCFException.class)) {
                PCFException pcfe = (PCFException)e;
                if (pcfe.reasonCode == 2085) {
                    ctx.logOutput("No Clusters found for the QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"");
                    return true;
                }
            }
            pcfCM.displayException(e, ctx);
            return false;
        }
        return true;
    }

    protected void readPCFMessageResponse(StepExecutionContext ctx, PCFMessage[] pcfResponse) {
        if (pcfResponse != null) {
            StringBuffer sb = new StringBuffer();
            boolean firstTime = true;
            for (PCFMessage pcfMessage : pcfResponse) {
                if (!firstTime) {
                    sb.append(",");
                }
                sb.append(((String)pcfMessage.getParameterValue(2029)).trim());
                firstTime = false;
            }
            this.wmqQmanager.setClusterName(sb.toString());
            ctx.logOutput("The queue manager \"" + this.wmqQmanager.getQueueManagerName() + "\" is a member of below clusters:\n" + this.wmqQmanager.getClusterName());
        } else {
            ctx.logOutput("Response is null");
        }
    }

    public String getDescription() {
        return "Inquiring and displaying Clusters of a QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

