/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqSubscriptions;
import com.xebialabs.deployit.plugin.wmq.enums.WmqProperties;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVariableUserId;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.CreateWmqSubscriptionStep;
import com.xebialabs.deployit.plugin.wmq.utils.WmqHelper;

public class ModifyWmqSubscriptionStep
extends CreateWmqSubscriptionStep {
    protected void init() {
        if (this.wmqQmanager.getVersion() == WmqVersion.WMQ_60) {
            throw new ResolutionException("Subscription is not supported in MQV6");
        }
        this.mqCommand = 178;
    }

    public ModifyWmqSubscriptionStep(WmqSubscriptions wmqSubscriptions, WmqQueueManager wmqQManager) {
        super(wmqSubscriptions, wmqQManager);
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        pcfCmd.addParameter(3152, this.wmqSubscriptions.getSubscriptionName());
        if (WmqProperties.COMPATABILITY == this.wmqSubscriptions.getProperties()) {
            pcfCmd.addParameter(1271, 1);
        } else if (WmqProperties.NONE == this.wmqSubscriptions.getProperties()) {
            pcfCmd.addParameter(1271, 0);
        } else if (WmqProperties.RFH2 == this.wmqSubscriptions.getProperties()) {
            pcfCmd.addParameter(1271, 2);
        }
        if (WmqVariableUserId.ANY == this.wmqSubscriptions.getVariableUserId()) {
            pcfCmd.addParameter(1277, 2);
        } else if (WmqVariableUserId.FIXED == this.wmqSubscriptions.getVariableUserId()) {
            pcfCmd.addParameter(1277, 1);
        }
        pcfCmd.addParameter(3159, this.wmqSubscriptions.getUserData());
        pcfCmd.addParameter(3135, this.wmqSubscriptions.getApplicationIdentity());
        this.setPriorityValue(pcfCmd);
        if (this.wmqSubscriptions.getExpiry() != 0) {
            pcfCmd.addParameter(1244, this.wmqSubscriptions.getExpiry());
        }
    }

    private void setPriorityValue(PCFMessage pcfCmd) {
        if (this.wmqSubscriptions.getPublishPriority() != null) {
            int priorityValue = WmqHelper.getSubscriptionPriority(this.wmqSubscriptions.getPublishPriority().toString());
            pcfCmd.addParameter(1283, priorityValue);
        } else {
            pcfCmd.addParameter(1283, -3);
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Modifying the Subscriptions \"" + this.wmqSubscriptions.getSubscriptionName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Modify Subscriptions with PCF";
    }

    protected String getSuccessMessage() {
        return "The Subscriptions \"" + this.wmqSubscriptions.getSubscriptionName() + "\" is modified on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

