/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqTopic;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDurableSubscriptions;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonPersistentMessageDelivery;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPersistentMessageDelivery;
import com.xebialabs.deployit.plugin.wmq.enums.WmqProxySubscriptionBehavior;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPublicationScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSubscriptionScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTopicDefaultPersistence;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTopicDefaultPutResponseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqWildcardOperation;
import com.xebialabs.deployit.plugin.wmq.step.CreateWmqTopicStep;

public class ModifyWmqTopicStep
extends CreateWmqTopicStep {
    protected void init() {
        if (this.wmqQmanager.getVersion() == WmqVersion.WMQ_60) {
            throw new ResolutionException("Topic is not supported in MQV6");
        }
        this.mqCommand = 170;
    }

    public ModifyWmqTopicStep(WmqTopic wmqTopic, WmqQueueManager wmqQManager) {
        super(wmqTopic, wmqQManager);
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        pcfCmd.addParameter(2092, this.wmqTopic.getTopicName());
        pcfCmd.addParameter(2093, this.wmqTopic.getDescription());
        if (WmqDurableSubscriptions.AS_PARENT == this.wmqTopic.getDurablesubScriptions()) {
            pcfCmd.addParameter(175, 0);
        } else if (WmqDurableSubscriptions.ALLOWED == this.wmqTopic.getDurablesubScriptions()) {
            pcfCmd.addParameter(175, 1);
        } else if (WmqDurableSubscriptions.INHIBITED == this.wmqTopic.getDurablesubScriptions()) {
            pcfCmd.addParameter(175, 2);
        }
        if (WmqTopicDefaultPersistence.AS_PARENT == this.wmqTopic.getDefaultPersistence()) {
            pcfCmd.addParameter(185, -1);
        } else if (WmqTopicDefaultPersistence.PERSISTENT == this.wmqTopic.getDefaultPersistence()) {
            pcfCmd.addParameter(185, 1);
        } else if (WmqTopicDefaultPersistence.NOT_PERSISTENT == this.wmqTopic.getDefaultPersistence()) {
            pcfCmd.addParameter(185, 0);
        }
        if (this.wmqTopic.getDefaultPriority() < 0 || this.wmqTopic.getDefaultPriority() > 9) {
            pcfCmd.addParameter(6, -2);
        } else {
            pcfCmd.addParameter(6, this.wmqTopic.getDefaultPriority());
        }
        pcfCmd.addParameter(2096, this.wmqTopic.getModelDurableQueue());
        pcfCmd.addParameter(2097, this.wmqTopic.getModelNonDurableQueue());
        if (WmqPublicationScope.AS_PARENT == this.wmqTopic.getPublicationScope()) {
            pcfCmd.addParameter(219, 1);
        } else if (WmqPublicationScope.QUEUE_MANAGER == this.wmqTopic.getPublicationScope()) {
            pcfCmd.addParameter(219, 4);
        } else if (WmqPublicationScope.ALL == this.wmqTopic.getPublicationScope()) {
            pcfCmd.addParameter(219, 0);
        }
        if (WmqSubscriptionScope.AS_PARENT == this.wmqTopic.getSubscriptionScope()) {
            pcfCmd.addParameter(218, 1);
        } else if (WmqSubscriptionScope.QUEUE_MANAGER == this.wmqTopic.getSubscriptionScope()) {
            pcfCmd.addParameter(218, 4);
        } else if (WmqSubscriptionScope.ALL == this.wmqTopic.getSubscriptionScope()) {
            pcfCmd.addParameter(218, 0);
        }
        if (WmqTopicDefaultPutResponseType.AS_PARENT == this.wmqTopic.getDefaultPutResponseType()) {
            pcfCmd.addParameter(184, 0);
        } else if (WmqTopicDefaultPutResponseType.SYNCRONOUS == this.wmqTopic.getDefaultPutResponseType()) {
            pcfCmd.addParameter(184, 1);
        } else if (WmqTopicDefaultPutResponseType.ASYNCHRONOUS == this.wmqTopic.getDefaultPutResponseType()) {
            pcfCmd.addParameter(184, 2);
        }
        if (WmqNonPersistentMessageDelivery.AS_PARENT == this.wmqTopic.getNonPersistentMessageDelivery()) {
            pcfCmd.addParameter(196, 0);
        } else if (WmqNonPersistentMessageDelivery.TO_ALL_SUBSCRIBERS == this.wmqTopic.getNonPersistentMessageDelivery()) {
            pcfCmd.addParameter(196, 1);
        } else if (WmqNonPersistentMessageDelivery.TO_ALL_DURABLE_SUBSCRIBERS == this.wmqTopic.getNonPersistentMessageDelivery()) {
            pcfCmd.addParameter(196, 2);
        } else if (WmqNonPersistentMessageDelivery.TO_ALL_AVILABLE_SUBSCRIBERS == this.wmqTopic.getNonPersistentMessageDelivery()) {
            pcfCmd.addParameter(196, 3);
        }
        if (WmqPersistentMessageDelivery.AS_PARENT == this.wmqTopic.getPersistentMessageDelivery()) {
            pcfCmd.addParameter(195, 0);
        } else if (WmqPersistentMessageDelivery.TO_ALL_SUBSCRIBERS == this.wmqTopic.getPersistentMessageDelivery()) {
            pcfCmd.addParameter(195, 1);
        } else if (WmqPersistentMessageDelivery.TO_ALL_DURABLE_SUBSCRIBERS == this.wmqTopic.getPersistentMessageDelivery()) {
            pcfCmd.addParameter(195, 2);
        } else if (WmqPersistentMessageDelivery.TO_ALL_AVILABLE_SUBSCRIBERS == this.wmqTopic.getPersistentMessageDelivery()) {
            pcfCmd.addParameter(195, 3);
        }
        if (WmqWildcardOperation.PASSTHROUGH == this.wmqTopic.getWildcardOperation()) {
            pcfCmd.addParameter(216, 2);
        } else if (WmqWildcardOperation.BLOCK == this.wmqTopic.getWildcardOperation()) {
            pcfCmd.addParameter(216, 1);
        }
        if (WmqProxySubscriptionBehavior.FIRST_USE == this.wmqTopic.getProxySubscriptionBehavior()) {
            pcfCmd.addParameter(199, 2);
        } else if (WmqProxySubscriptionBehavior.FORCE == this.wmqTopic.getProxySubscriptionBehavior()) {
            pcfCmd.addParameter(199, 1);
        }
        pcfCmd.addParameter(2029, this.wmqTopic.getClusterName());
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Modifying the Topic \"" + this.wmqTopic.getTopicName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Modify Topic with PCF";
    }

    protected String getSuccessMessage() {
        return "The Topic \"" + this.wmqTopic.getTopicName() + "\" is modified on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

