/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.utils.RegexUtils;

public class RetrieveWmqVersionStep
implements Step {
    private WmqQueueManager wmqQueueManager;

    public RetrieveWmqVersionStep(WmqQueueManager wmqQueueManager) {
        this.wmqQueueManager = wmqQueueManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession hostSession = this.wmqQueueManager.getHostName().getHostSession();
        try {
            CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
            int res = hostSession.execute((CommandExecutionCallbackHandler)capturedOutput, new String[]{"dspmqver"});
            if (res != 0) {
                ctx.logError("Non-zero exitcode from dspmqver: " + res);
                boolean bl = false;
                return bl;
            }
            for (String eachLine : capturedOutput.getOutputLines()) {
                String[] matches;
                if (!eachLine.startsWith("Version") || (matches = RegexUtils.regexMatch(eachLine, "Version:\\s+(\\d+)\\.(\\d+)\\.[\\d\\.]*")) == null || matches.length != 2) continue;
                int majorVersion = Integer.parseInt(matches[0]);
                if (majorVersion == 6) {
                    this.wmqQueueManager.setVersion(WmqVersion.WMQ_60);
                    ctx.logOutput("Installation of MQ Series on the Host \t " + this.wmqQueueManager.getHostName() + "  \t is " + majorVersion);
                    boolean bl = true;
                    return bl;
                }
                if (majorVersion != 7) continue;
                ctx.logOutput("Installation of MQ Series on the Host \t " + this.wmqQueueManager.getHostName() + " \t is " + majorVersion);
                this.wmqQueueManager.setVersion(WmqVersion.WMQ_70);
                boolean bl = true;
                return bl;
            }
            ctx.logError("Could not determine installed version of MQ Series ");
            boolean bl = false;
            return bl;
        }
        finally {
            hostSession.close();
        }
    }

    public String getDescription() {
        return "Retrieving the Version of WebSphereMQ on the Host \t " + this.wmqQueueManager.getHostName();
    }
}

