/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wmq.enums.WmqBaseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultPutResponseType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultReadAhead;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "The MQAliasQueue class represents an individual alias queue defined on a particular queue manager. Enumerating an object of this class results in an empty list.")
public class WmqAliasQueue extends WmqBaseAliasQueue {

	@ConfigurationItemProperty(required = false, label = "MQ Version", description = "Specify type of MQ Version")
	private WmqVersion version;

	@ConfigurationItemProperty(required = false, label = "Type of BaseObject", description = "We can specify the type of the queue BaseObject")
	private WmqBaseType baseType;

	@ConfigurationItemProperty(required = false, label = "Default read ahead", description = "We can specify the DEFAULT READ AHEAD option for a queue by setting the options YES or NO or DISABLED ", category = "Extended")
	private WmqDefaultReadAhead defaultReadAhead;

	@ConfigurationItemProperty(required = false, label = "Property Control", description = "Specifies how message properties are handled when messages are retrieved from queues using the MQGET call with the MQGMO_PROPERTIES_AS_Q_DEF option by setting the options.", category = "Extended")
	private WmqPropertyControl propertyControl;

	@ConfigurationItemProperty(label = "Default put response type", description = "The parameter specifies the type of response to be used for put operations to the queue when an application specifies MQPMO_RESPONSE_AS_Q_DEF by setting the options Synchronous and Asynchronous.", category = "Extended")
	private WmqDefaultPutResponseType defaultPutResponseType;

	public WmqVersion getVersion() {
		return version;
	}

	public void setVersion(WmqVersion version) {
		this.version = version;
	}

	public WmqBaseType getBaseType() {
		return baseType;
	}

	public void setBaseType(WmqBaseType baseType) {
		this.baseType = baseType;
	}

	public WmqDefaultReadAhead getDefaultReadAhead() {
		return defaultReadAhead;
	}

	public void setDefaultReadAhead(WmqDefaultReadAhead defaultReadAhead) {
		this.defaultReadAhead = defaultReadAhead;
	}

	public WmqPropertyControl getPropertyControl() {
		return propertyControl;
	}

	public void setPropertyControl(WmqPropertyControl propertyControl) {
		this.propertyControl = propertyControl;
	}

	public WmqDefaultPutResponseType getDefaultPutResponseType() {
		return defaultPutResponseType;
	}

	public void setDefaultPutResponseType(WmqDefaultPutResponseType defaultPutResponseType) {
		this.defaultPutResponseType = defaultPutResponseType;
	}

}
