/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMCAType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPutAuthority;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "The MQRequesterChannel class represents an individual requester channel on a particular queue manager. Enumerating an object of this class results in an empty list.")
public class WmqRequesterChannel extends WmqChannel {

	@ConfigurationItemProperty(required = true, label = "Connection name", description = "Type the name of the computer that hosts the target queue manager.")
	private String connectionName;

	@ConfigurationItemProperty(label = "Local communication address", description = "Local communications address for the channel.")
	private String localCommunicationAddress;

	@ConfigurationItemProperty(label = "Sequence number wrap", description = "range from 100 to 999 999 999.", category = "Extended")
	private int sequenceNumberWrap = 999999999;

	@ConfigurationItemProperty(label = "Message compression", description = "range from 100 to 999 999 999.", category = "Extended")
	private WmqChannelMessageCompression messageCompression;

	@ConfigurationItemProperty(label = "Non-persistent message speed", category = "Extended")
	private WmqNonpersistentMessageSpeed nonPersistentMessageSpeed;

	@ConfigurationItemProperty(label = "Batch size", description = "Type the maximum number of messages to be sent before syncpoint is taken", category = "Extended")
	private int batchSize = 50;

	@ConfigurationItemProperty(label = "Put authority", description = "To establish authority to put the message on the destination queue. ", category = "Extended")
	private WmqChannelPutAuthority putAuthority;

	@ConfigurationItemProperty(label = "Message exit name", description = "Message exits operate only on message channels and normally work in pairs.(Give multiple names with comma seperated)", category = "Exit")
	private String messageExitName;

	@ConfigurationItemProperty(label = "Message exit user data", description = "Specifies user data that is passed to the message exit(Give multiple names with comma seperated).", category = "Exit")
	private String messageExitUserData;

	@ConfigurationItemProperty(label = "MCA user ID", description = "Type the user identifier, up to 12 characters.", category = "MCA")
	private String mcaUserID;

	@ConfigurationItemProperty(label = "MCA type", category = "MCA")
	private WmqChannelMCAType mcaType;

	@ConfigurationItemProperty(label = "Message retry count", description = "Specifies the number of times that a failing message should be retried. Specify a value in the range 0 to 999 999 999.", category = "Message retry")
	private int messageRetryCount = 10;

	@ConfigurationItemProperty(label = "Message retry interval", description = "Specifies the minimum time interval in milliseconds between retries of failing messages.Specify a value in the range 0 to 999 999 999.", category = "Message retry")
	private int messageRetryInterval = 1000;

	@ConfigurationItemProperty(label = "Message retry exit name", description = "Specifies the number of times that a failing message should be retried. Specify a value in the range 0 to 999 999 999.", category = "Message retry")
	private String messageRetryExitname;

	@ConfigurationItemProperty(label = "Message retry exit user data", description = "Specifies user data that is passed to the message exit. ", category = "Message retry")
	private String messageRetryExitUserData;

	@ConfigurationItemProperty(label = "Channel monitoring", description = "the rate at which the data is collected.", category = "Statistics")
	private WmqChannelMonitoring channelMonitoring;

	@ConfigurationItemProperty(label = "Channel statistics", description = "the rate at which the data is collected.", category = "Statistics")
	private WmqChannelStatisticTypes channelStatistics;

	public String getConnectionName() {
		return connectionName;
	}

	public void setConnectionName(String connectionName) {
		this.connectionName = connectionName;
	}

	public String getLocalCommunicationAddress() {
		return localCommunicationAddress;
	}

	public void setLocalCommunicationAddress(String localCommunicationAddress) {
		this.localCommunicationAddress = localCommunicationAddress;
	}

	public int getSequenceNumberWrap() {
		return sequenceNumberWrap;
	}

	public void setSequenceNumberWrap(int sequenceNumberWrap) {
		this.sequenceNumberWrap = sequenceNumberWrap;
	}

	public WmqChannelMessageCompression getMessageCompression() {
		return messageCompression;
	}

	public void setMessageCompression(WmqChannelMessageCompression messageCompression) {
		this.messageCompression = messageCompression;
	}

	public WmqNonpersistentMessageSpeed getNonPersistentMessageSpeed() {
		return nonPersistentMessageSpeed;
	}

	public void setNonPersistentMessageSpeed(WmqNonpersistentMessageSpeed nonPersistentMessageSpeed) {
		this.nonPersistentMessageSpeed = nonPersistentMessageSpeed;
	}

	public int getBatchSize() {
		return batchSize;
	}

	public void setBatchSize(int batchSize) {
		this.batchSize = batchSize;
	}

	public WmqChannelPutAuthority getPutAuthority() {
		return putAuthority;
	}

	public void setPutAuthority(WmqChannelPutAuthority putAuthority) {
		this.putAuthority = putAuthority;
	}

	public String getMcaUserID() {
		return mcaUserID;
	}

	public void setMcaUserID(String mcaUserID) {
		this.mcaUserID = mcaUserID;
	}

	public WmqChannelMCAType getMcaType() {
		return mcaType;
	}

	public void setMcaType(WmqChannelMCAType mcaType) {
		this.mcaType = mcaType;
	}

	public int getMessageRetryCount() {
		return messageRetryCount;
	}

	public void setMessageRetryCount(int messageRetryCount) {
		this.messageRetryCount = messageRetryCount;
	}

	public int getMessageRetryInterval() {
		return messageRetryInterval;
	}

	public void setMessageRetryInterval(int messageRetryInterval) {
		this.messageRetryInterval = messageRetryInterval;
	}

	public String getMessageRetryExitname() {
		return messageRetryExitname;
	}

	public void setMessageRetryExitname(String messageRetryExitname) {
		this.messageRetryExitname = messageRetryExitname;
	}

	public String getMessageRetryExitUserData() {
		return messageRetryExitUserData;
	}

	public void setMessageRetryExitUserData(String messageRetryExitUserData) {
		this.messageRetryExitUserData = messageRetryExitUserData;
	}

	public WmqChannelMonitoring getChannelMonitoring() {
		return channelMonitoring;
	}

	public void setChannelMonitoring(WmqChannelMonitoring channelMonitoring) {
		this.channelMonitoring = channelMonitoring;
	}

	public WmqChannelStatisticTypes getChannelStatistics() {
		return channelStatistics;
	}

	public void setChannelStatistics(WmqChannelStatisticTypes channelStatistics) {
		this.channelStatistics = channelStatistics;
	}

	public String getMessageExitName() {
		return messageExitName;
	}

	public void setMessageExitName(String messageExitName) {
		this.messageExitName = messageExitName;
	}

	public String getMessageExitUserData() {
		return messageExitUserData;
	}

	public void setMessageExitUserData(String messageExitUserData) {
		this.messageExitUserData = messageExitUserData;
	}

}
