/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDestinationClass;
import com.xebialabs.deployit.plugin.wmq.enums.WmqProperties;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPublishPriority;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVariableUserId;
import com.xebialabs.deployit.plugin.wmq.enums.WmqWildCardUsage;

@SuppressWarnings("serial")
@ConfigurationItem(category = "middleware", description = "An MQ subscriptions is an MQ object that identifies what a subscribe is about.")
public class WmqSubscriptions extends BaseConfigurationItem implements WmqResource {

	@ConfigurationItemProperty(required = true, label = "Subscription name", identifying = true, description = "You cannot change the name of the subscription after it has been created.")
	private String subscriptionName;

	@ConfigurationItemProperty(required = true, label = "Topic name", description = "The name of the topic object used by the subscription. The topic name provides an optional topic root. A maximum of 48 characters are allowed.")
	private String topicName;

	@ConfigurationItemProperty(required = false, label = "Topic string ", description = "This specifies a fully qualified topic name or wildcard topic set for the subscription.")
	private String topicString;

	@ConfigurationItemProperty(required = false, label = "Scope", description = "The scope determines whether the subscription is passed to other queue managers in the network.")
	private WmqSScope scope;

	@ConfigurationItemProperty(required = true, label = "Destination class", description = "The Destination class specifies whether the destination used by the subscription  is a managed destination.if you choose MQDC_MANAGED,you need not provide DestinationQueueManager and destination name,otherwise you have to provide. ")
	private WmqDestinationClass destinationClass;

	@ConfigurationItemProperty(required = false, label = "Destination queue manager", description = "The destination queue manager for messages published to the subscription.")
	private String destinationQueueManager;

	@ConfigurationItemProperty(required = false, label = "Destination name ", description = "This is the destination for messages published to the subscription. In MQ V7, this will always be a queue name.")
	private String destinationName;

	@ConfigurationItemProperty(required = false, label = "properties ", description = "Properties  determines how pub/sub related message properties  are added to messages sent to the subscription.")
	private WmqProperties properties;

	@ConfigurationItemProperty(required = false, label = "Selector", description = "The type of SelectionString that has been specified. This display attribute is calculated and is not associated with an object. The selector type will be filterable (for example, with a WHERE clause) to allow an administrator to display only internal or only external selectors.")
	private String selector;

	@ConfigurationItemProperty(required = false, label = "Variable User Id", description = "Specifies whether users other then the creator of the subscription, can connect to it and take ownership of the subscription.", category = "Extended")
	private WmqVariableUserId variableUserId;

	@ConfigurationItemProperty(required = false, label = "User Data", description = "The value of User Data  can be optionally passed as a message property in a message sent to the subscription. ", category = "Extended")
	private String userData;

	@ConfigurationItemProperty(required = false, label = "Application Identity", description = "The value of Application Identity will be used for messages sent to the subscription. If Application Identity is not specified, then an empty default value is used.", category = "Extended")
	private String applicationIdentity;

	@ConfigurationItemProperty(required = false, label = "Publish priority", description = "The Publish priority  determines the manner in which pub/sub related message properties are added to the messages sent to the subscription.", category = "Extended")
	private WmqPublishPriority publishPriority;

	@ConfigurationItemProperty(required = false, label = "Expiry", description = "The time to live of the subscription  from the creation date and time. Expiry is measured in tenths of a second.The default value of unlimited means that the subscription never expires.", category = "Extended")
	private int expiry;

	@ConfigurationItemProperty(required = false, label = "Wildcard usage", description = "The scheme is used when interpreting any wildcard characters contained in the Topic String.")
	private WmqWildCardUsage wildCardUsage;

	@ConfigurationItemProperty(required = false, label = "Subscription Level", description = "Start of changeThe level within the subscription interception hierarchy at which this subscription is made.An integer in the range 0-9. The default value is 1.", category = "Extended")
	private int subscriptionLevel = 1;

	public String getSubscriptionName() {
		return subscriptionName;
	}

	public void setSubscriptionName(String subscriptionName) {
		this.subscriptionName = subscriptionName;
	}

	public String getTopicName() {
		return topicName;
	}

	public void setTopicName(String topicName) {
		this.topicName = topicName;
	}

	public String getTopicString() {
		return topicString;
	}

	public void setTopicString(String topicString) {
		this.topicString = topicString;
	}

	public String getDestinationQueueManager() {
		return destinationQueueManager;
	}

	public void setDestinationQueueManager(String destinationQueueManager) {
		this.destinationQueueManager = destinationQueueManager;
	}

	public String getDestinationName() {
		return destinationName;
	}

	public void setDestinationName(String destinationName) {
		this.destinationName = destinationName;
	}

	public String getUserData() {
		return userData;
	}

	public void setUserData(String userData) {
		this.userData = userData;
	}

	public String getApplicationIdentity() {
		return applicationIdentity;
	}

	public void setApplicationIdentity(String applicationIdentity) {
		this.applicationIdentity = applicationIdentity;
	}

	public WmqPublishPriority getPublishPriority() {
		return publishPriority;
	}

	public void setPublishPriority(WmqPublishPriority publishPriority) {
		this.publishPriority = publishPriority;
	}

	public WmqWildCardUsage getWildCardUsage() {
		return wildCardUsage;
	}

	public void setWildCardUsage(WmqWildCardUsage wildCardUsage) {
		this.wildCardUsage = wildCardUsage;
	}

	public WmqSScope getScope() {
		return scope;
	}

	public void setScope(WmqSScope scope) {
		this.scope = scope;
	}

	public WmqDestinationClass getDestinationClass() {
		return destinationClass;
	}

	public void setDestinationClass(WmqDestinationClass destinationClass) {
		this.destinationClass = destinationClass;
	}

	public WmqProperties getProperties() {
		return properties;
	}

	public void setProperties(WmqProperties properties) {
		this.properties = properties;
	}

	public WmqVariableUserId getVariableUserId() {
		return variableUserId;
	}

	public void setVariableUserId(WmqVariableUserId variableUserId) {
		this.variableUserId = variableUserId;
	}

	public int getSubscriptionLevel() {
		return subscriptionLevel;
	}

	public void setSubscriptionLevel(int subscriptionLevel) {
		this.subscriptionLevel = subscriptionLevel;
	}

	public String getSelector() {
		return selector;
	}

	public void setSelector(String selector) {
		this.selector = selector;
	}

	public int getExpiry() {
		return expiry;
	}

	public void setExpiry(int expiry) {
		this.expiry = expiry;
	}

}
