/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqNamelist;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqNamelist} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqNamelistStep extends BaseWmqStep {

	public WmqNamelist wmqNamelist;

	@Override
	protected void init() {

		this.mqCommand = MQConstants.MQCMD_CREATE_NAMELIST;
	}

	public CreateWmqNamelistStep(WmqNamelist wmqNamelist, WmqQueueManager wmqQmanager) {
		this.wmqNamelist = wmqNamelist;
		this.wmqQmanager = wmqQmanager;
	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// Name of the Namelist to be created. - Manadatory.

		pcfCmd.addParameter(MQConstants.MQCA_NAMELIST_NAME, wmqNamelist.getNameListName());

		// Mention the Names to be stored in the Namelist seperated by a comma.

		String nameList = wmqNamelist.getNames();
		if (nameList != null) {
			if (nameList.indexOf(",") > 0) {
				String[] listNames = nameList.split(",");
				pcfCmd.addParameter(MQConstants.MQCA_NAMES, listNames);

			} else {
				pcfCmd.addParameter(MQConstants.MQCA_NAMES, nameList);
			}

		}

		// Description of the Namelist.
		if (StringUtils.isNotBlank(wmqNamelist.getDescription())) {
			pcfCmd.addParameter(MQConstants.MQCA_NAMELIST_DESC, wmqNamelist.getDescription());
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating Namelist \"" + wmqNamelist.getNameListName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Creating Namelist Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The Namelist \"" + wmqNamelist.getNameListName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";

	}

}
