/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.utils;

import java.io.IOException;

import com.ibm.mq.MQException;
import com.ibm.mq.constants.CMQC;
import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.pcf.PCFException;
import com.ibm.mq.headers.pcf.PCFMessageAgent;
import com.xebialabs.deployit.StepExecutionContext;

public class PCF_CommonMethods {

	public String queueManager = "*";
	public String host = "localhost";
	public int port = 1414;
	public String channel = "SYSTEM.DEF.SVRCONN";
	public PCFMessageAgent agent = null;
	public boolean client = false;

	public void createAgent(int numOfArgs) throws MQDataException {
		if (numOfArgs == 1) {
			client = false;
			// Connect to the local queue manager.
			agent = new PCFMessageAgent(queueManager);
		} else {
			client = true;
			// Connect to the client and define the queue manager host, port and
			// channel.
			// Notice that the method does not take a queue manager name. It is
			// assuming that the
			// default QM will be used.
			agent = new PCFMessageAgent(host, port, channel);
		}
	}

	public void destroyAgent() throws MQDataException {
		// Disconnect the agent.
		agent.disconnect();
	}

	public void displayException(Exception exception, StepExecutionContext ctx) {
		if (exception.getClass().equals(PCFException.class)) {
			// PCFException exception handling.
			PCFException pcfe = (PCFException) exception;

			if (pcfe.reasonCode == MQConstants.MQRCCF_OBJECT_ALREADY_EXISTS) {
				ctx.logOutput("The Name already exists on the queue manager.");
			} else if (pcfe.reasonCode == MQConstants.MQRCCF_CHANNEL_NOT_FOUND) {
				if (client) {
					ctx.logError("Either the queue manager \"" + queueManager + "\"");
				} else {
					ctx.logError("Either the default queue manager");
				}
			} else {
				ctx.logError(pcfe + ": " + MQConstants.lookupReasonCode(pcfe.reasonCode));
			}
		} else if (exception.getClass().equals(IOException.class)) {
			// IOException exception handling.
			IOException ioe = (IOException) exception;

			ctx.logError("IOException:" + ioe);
		} else if (exception.getClass().equals(MQDataException.class)) {
			// MQDataException exception handling.
			MQDataException de = (MQDataException) exception;

			ctx.logError(de + ": " + MQConstants.lookupReasonCode(de.reasonCode));
		} else if (exception.getClass().equals(MQException.class)) {
			// MQException exception handling.
			MQException mqe = (MQException) exception;

			if (mqe.reasonCode == CMQC.MQRC_UNKNOWN_OBJECT_NAME) {
				ctx.logError("Unknown Object name");
			} else {
				ctx.logError(mqe + ": " + MQConstants.lookupReasonCode(mqe.reasonCode));
			}
		} else {
			ctx.logError("Exception:" + exception.getMessage());
		}
	}

	public String getQueueManager() {
		return queueManager;
	}

	public void setQueueManager(String queueManager) {
		this.queueManager = queueManager;
	}

	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getChannel() {
		return channel;
	}

	public void setChannel(String channel) {
		this.channel = channel;
	}

}
