/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wmq.ci.WmqResource;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDestinationClass;
import com.xebialabs.deployit.plugin.wmq.enums.WmqProperties;
import com.xebialabs.deployit.plugin.wmq.enums.WmqPublishPriority;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVariableUserId;
import com.xebialabs.deployit.plugin.wmq.enums.WmqWildCardUsage;

@ConfigurationItem(category="middleware", description="An MQ subscriptions is an MQ object that identifies what a subscribe is about.")
public class WmqSubscriptions
extends BaseConfigurationItem
implements WmqResource {
    @ConfigurationItemProperty(required=true, label="Subscription name", identifying=true, description="You cannot change the name of the subscription after it has been created.")
    private String subscriptionName;
    @ConfigurationItemProperty(required=true, label="Topic name", description="The name of the topic object used by the subscription. The topic name provides an optional topic root. A maximum of 48 characters are allowed.")
    private String topicName;
    @ConfigurationItemProperty(required=false, label="Topic string ", description="This specifies a fully qualified topic name or wildcard topic set for the subscription.")
    private String topicString;
    @ConfigurationItemProperty(required=false, label="Scope", description="The scope determines whether the subscription is passed to other queue managers in the network.")
    private WmqSScope scope;
    @ConfigurationItemProperty(required=true, label="Destination class", description="The Destination class specifies whether the destination used by the subscription  is a managed destination.if you choose MQDC_MANAGED,you need not provide DestinationQueueManager and destination name,otherwise you have to provide. ")
    private WmqDestinationClass destinationClass;
    @ConfigurationItemProperty(required=false, label="Destination queue manager", description="The destination queue manager for messages published to the subscription.")
    private String destinationQueueManager;
    @ConfigurationItemProperty(required=false, label="Destination name ", description="This is the destination for messages published to the subscription. In MQ V7, this will always be a queue name.")
    private String destinationName;
    @ConfigurationItemProperty(required=false, label="properties ", description="Properties  determines how pub/sub related message properties  are added to messages sent to the subscription.")
    private WmqProperties properties;
    @ConfigurationItemProperty(required=false, label="Selector", description="The type of SelectionString that has been specified. This display attribute is calculated and is not associated with an object. The selector type will be filterable (for example, with a WHERE clause) to allow an administrator to display only internal or only external selectors.")
    private String selector;
    @ConfigurationItemProperty(required=false, label="Variable User Id", description="Specifies whether users other then the creator of the subscription, can connect to it and take ownership of the subscription.", category="Extended")
    private WmqVariableUserId variableUserId;
    @ConfigurationItemProperty(required=false, label="User Data", description="The value of User Data  can be optionally passed as a message property in a message sent to the subscription. ", category="Extended")
    private String userData;
    @ConfigurationItemProperty(required=false, label="Application Identity", description="The value of Application Identity will be used for messages sent to the subscription. If Application Identity is not specified, then an empty default value is used.", category="Extended")
    private String applicationIdentity;
    @ConfigurationItemProperty(required=false, label="Publish priority", description="The Publish priority  determines the manner in which pub/sub related message properties are added to the messages sent to the subscription.", category="Extended")
    private WmqPublishPriority publishPriority;
    @ConfigurationItemProperty(required=false, label="Expiry", description="The time to live of the subscription  from the creation date and time. Expiry is measured in tenths of a second.The default value of unlimited means that the subscription never expires.", category="Extended")
    private int expiry;
    @ConfigurationItemProperty(required=false, label="Wildcard usage", description="The scheme is used when interpreting any wildcard characters contained in the Topic String.")
    private WmqWildCardUsage wildCardUsage;
    @ConfigurationItemProperty(required=false, label="Subscription Level", description="Start of changeThe level within the subscription interception hierarchy at which this subscription is made.An integer in the range 0-9. The default value is 1.", category="Extended")
    private int subscriptionLevel = 1;

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getTopicString() {
        return this.topicString;
    }

    public void setTopicString(String topicString) {
        this.topicString = topicString;
    }

    public String getDestinationQueueManager() {
        return this.destinationQueueManager;
    }

    public void setDestinationQueueManager(String destinationQueueManager) {
        this.destinationQueueManager = destinationQueueManager;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getApplicationIdentity() {
        return this.applicationIdentity;
    }

    public void setApplicationIdentity(String applicationIdentity) {
        this.applicationIdentity = applicationIdentity;
    }

    public WmqPublishPriority getPublishPriority() {
        return this.publishPriority;
    }

    public void setPublishPriority(WmqPublishPriority publishPriority) {
        this.publishPriority = publishPriority;
    }

    public WmqWildCardUsage getWildCardUsage() {
        return this.wildCardUsage;
    }

    public void setWildCardUsage(WmqWildCardUsage wildCardUsage) {
        this.wildCardUsage = wildCardUsage;
    }

    public WmqSScope getScope() {
        return this.scope;
    }

    public void setScope(WmqSScope scope) {
        this.scope = scope;
    }

    public WmqDestinationClass getDestinationClass() {
        return this.destinationClass;
    }

    public void setDestinationClass(WmqDestinationClass destinationClass) {
        this.destinationClass = destinationClass;
    }

    public WmqProperties getProperties() {
        return this.properties;
    }

    public void setProperties(WmqProperties properties) {
        this.properties = properties;
    }

    public WmqVariableUserId getVariableUserId() {
        return this.variableUserId;
    }

    public void setVariableUserId(WmqVariableUserId variableUserId) {
        this.variableUserId = variableUserId;
    }

    public int getSubscriptionLevel() {
        return this.subscriptionLevel;
    }

    public void setSubscriptionLevel(int subscriptionLevel) {
        this.subscriptionLevel = subscriptionLevel;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }
}

