/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqProcessDefinition;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqApplicationType;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;

public class CreateWmqProcessDefinitionStep
extends BaseWmqStep {
    public WmqProcessDefinition wmqProcessDefinition;

    protected void init() {
        this.mqCommand = 5;
    }

    public CreateWmqProcessDefinitionStep(WmqProcessDefinition wmqProcessDefinition, WmqQueueManager wmqQmanager) {
        this.wmqProcessDefinition = wmqProcessDefinition;
        this.wmqQmanager = wmqQmanager;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {
        pcfCmd.addParameter(2012, this.wmqProcessDefinition.getProcessName());
        if (this.wmqProcessDefinition.getDescription() != null && !"".equals(this.wmqProcessDefinition.getDescription())) {
            pcfCmd.addParameter(2011, this.wmqProcessDefinition.getDescription());
        }
        if (this.wmqProcessDefinition.getApplicationType() != null && this.wmqProcessDefinition.getApplicationTypeInt() >= 65536 && this.wmqProcessDefinition.getApplicationTypeInt() < 999999999) {
            throw new MQPluginException("ApplicationType and ApplicationTypeInt both should not be given at a time in CI");
        }
        if (this.wmqProcessDefinition.getApplicationTypeInt() >= 65536 && this.wmqProcessDefinition.getApplicationTypeInt() < 999999999) {
            pcfCmd.addParameter(1, this.wmqProcessDefinition.getApplicationTypeInt());
        }
        if (WmqApplicationType.WINDOWS_NT == this.wmqProcessDefinition.getApplicationType()) {
            pcfCmd.addParameter(1, 11);
        } else if (WmqApplicationType.WINDOWS == this.wmqProcessDefinition.getApplicationType()) {
            pcfCmd.addParameter(1, 9);
        } else if (WmqApplicationType.DEFAULT == this.wmqProcessDefinition.getApplicationType()) {
            pcfCmd.addParameter(1, 28);
        } else if (WmqApplicationType.UNIX == this.wmqProcessDefinition.getApplicationType()) {
            pcfCmd.addParameter(1, 6);
        } else if (WmqApplicationType.DOS == this.wmqProcessDefinition.getApplicationType()) {
            pcfCmd.addParameter(1, 5);
        } else if (WmqApplicationType.CICS == this.wmqProcessDefinition.getApplicationType()) {
            pcfCmd.addParameter(1, 1);
        } else if (WmqApplicationType.OS400 == this.wmqProcessDefinition.getApplicationType()) {
            pcfCmd.addParameter(1, 8);
        }
        pcfCmd.addParameter(2001, this.wmqProcessDefinition.getApplicationId());
        if (this.wmqProcessDefinition.getEnvironmentData() != null && !"".equals(this.wmqProcessDefinition.getEnvironmentData())) {
            pcfCmd.addParameter(2007, this.wmqProcessDefinition.getEnvironmentData());
        }
        if (this.wmqProcessDefinition.getUserData() != null && !"".equals(this.wmqProcessDefinition.getUserData())) {
            pcfCmd.addParameter(2021, this.wmqProcessDefinition.getUserData());
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating ProcessDefinition \"" + this.wmqProcessDefinition.getProcessName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating ProcessDefinition Step";
    }

    protected String getSuccessMessage() {
        return "The ProcessDefinition \"" + this.wmqProcessDefinition.getProcessName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

