/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqSenderChannel;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMCAType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDataConversion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

public class CreateWmqSenderChannelStep
extends BaseWmqStep {
    public WmqSenderChannel wmqSenderChannel;

    public CreateWmqSenderChannelStep(WmqSenderChannel wmqSenderChannel, WmqQueueManager wmqQmanager) {
        this.wmqSenderChannel = wmqSenderChannel;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        this.mqCommand = 23;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        int[] list;
        pcfCmd.addParameter(3501, this.wmqSenderChannel.getChannelName());
        pcfCmd.addParameter(1511, 1);
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getDescription())) {
            pcfCmd.addParameter(3502, this.wmqSenderChannel.getDescription());
        }
        if (WmqTransmissionProtocolTypes.LU6 == this.wmqSenderChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 1);
        } else if (WmqTransmissionProtocolTypes.NET_BIOS == this.wmqSenderChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 3);
        } else if (WmqTransmissionProtocolTypes.SPX == this.wmqSenderChannel.getTransportType()) {
            pcfCmd.addParameter(1501, 4);
        } else {
            pcfCmd.addParameter(1501, 2);
        }
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getConnectionName())) {
            pcfCmd.addParameter(3506, this.wmqSenderChannel.getConnectionName());
        }
        pcfCmd.addParameter(3505, this.wmqSenderChannel.getTransmissionQueue());
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getLocalCommunicationAddress())) {
            pcfCmd.addParameter(3520, this.wmqSenderChannel.getLocalCommunicationAddress());
        }
        if (WmqHeaderCompression.SYSTEM == this.wmqSenderChannel.getHeaderCompression()) {
            list = new int[]{8};
            pcfCmd.addParameter(1575, list);
        } else {
            list = new int[]{0};
            pcfCmd.addParameter(1575, list);
        }
        if (this.wmqSenderChannel.getKeepAliveInterval() > -1 && this.wmqSenderChannel.getKeepAliveInterval() <= 99999) {
            pcfCmd.addParameter(1566, this.wmqSenderChannel.getKeepAliveInterval());
        }
        pcfCmd.addParameter(1563, this.wmqSenderChannel.getHeartBeatInterval());
        pcfCmd.addParameter(1510, this.wmqSenderChannel.getMaximumMessageLength());
        if (this.wmqSenderChannel.getSequenceNumberWrap() < 100) {
            pcfCmd.addParameter(1509, 999999999);
        } else if (this.wmqSenderChannel.getSequenceNumberWrap() != 0) {
            pcfCmd.addParameter(1509, this.wmqSenderChannel.getSequenceNumberWrap());
        }
        int[] messageCompressionList = new int[1];
        if (WmqMessageCompression.RLE == this.wmqSenderChannel.getMessageCompression()) {
            messageCompressionList[0] = 1;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else if (WmqMessageCompression.ZLIBFAST == this.wmqSenderChannel.getMessageCompression()) {
            messageCompressionList[0] = 2;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else if (WmqMessageCompression.ZLIBHIGH == this.wmqSenderChannel.getMessageCompression()) {
            messageCompressionList[0] = 4;
            pcfCmd.addParameter(1576, messageCompressionList);
        } else {
            messageCompressionList[0] = 0;
            pcfCmd.addParameter(1576, messageCompressionList);
        }
        if (WmqNonpersistentMessageSpeed.NORMAL == this.wmqSenderChannel.getNonPersistentMessageSpeed()) {
            pcfCmd.addParameter(1562, 1);
        } else {
            pcfCmd.addParameter(1562, 2);
        }
        pcfCmd.addParameter(1502, this.wmqSenderChannel.getBatchSize());
        pcfCmd.addParameter(1564, this.wmqSenderChannel.getBatchInterval());
        pcfCmd.addParameter(1503, this.wmqSenderChannel.getDisconnectInterval());
        if (WmqDataConversion.CONVERSION == this.wmqSenderChannel.getDataConversion()) {
            pcfCmd.addParameter(1515, 1);
        } else {
            pcfCmd.addParameter(1515, 0);
        }
        pcfCmd.addParameter(1567, this.wmqSenderChannel.getBatchHeartBeatInterval());
        if (this.wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
            if (WmqChannelPropertyControl.ALL == this.wmqSenderChannel.getPropertyControl()) {
                pcfCmd.addParameter(190, 2);
            } else if (WmqChannelPropertyControl.NONE == this.wmqSenderChannel.getPropertyControl()) {
                pcfCmd.addParameter(190, 1);
            } else {
                pcfCmd.addParameter(190, 0);
            }
        }
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getMcaUserID())) {
            pcfCmd.addParameter(3527, this.wmqSenderChannel.getMcaUserID());
        }
        if (WmqChannelMCAType.THREAD == this.wmqSenderChannel.getMcaType()) {
            pcfCmd.addParameter(1517, 2);
        } else {
            pcfCmd.addParameter(1517, 1);
        }
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getSendExit())) {
            String[] sendExitList = StringUtils.split(this.wmqSenderChannel.getSendExit(), ",");
            pcfCmd.addParameter(3510, sendExitList);
        }
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getSendExitUserData())) {
            String[] sendExitUserDataList = StringUtils.split(this.wmqSenderChannel.getSendExitUserData(), ",");
            pcfCmd.addParameter(3515, sendExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getReceiveExit())) {
            String[] receiveExitList = StringUtils.split(this.wmqSenderChannel.getReceiveExit(), ",");
            pcfCmd.addParameter(3511, receiveExitList);
        }
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getReceiveExitUserData())) {
            String[] receiveExitUserDataList = StringUtils.split(this.wmqSenderChannel.getReceiveExitUserData(), ",");
            pcfCmd.addParameter(3516, receiveExitUserDataList);
        }
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getSecurityExit())) {
            pcfCmd.addParameter(3508, this.wmqSenderChannel.getSecurityExit());
        }
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getSecurityExitUserData())) {
            pcfCmd.addParameter(3513, this.wmqSenderChannel.getSecurityExitUserData());
        }
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getMessageExitName())) {
            String[] messageExitList = StringUtils.split(this.wmqSenderChannel.getMessageExitName(), ",");
            pcfCmd.addParameter(3509, messageExitList);
        }
        if (StringUtils.isNotBlank(this.wmqSenderChannel.getMessageExitUserData())) {
            String[] messageExitUserList = StringUtils.split(this.wmqSenderChannel.getMessageExitUserData(), ",");
            pcfCmd.addParameter(3514, messageExitUserList);
        }
        pcfCmd.addParameter(1505, this.wmqSenderChannel.getShortRetryCount());
        pcfCmd.addParameter(1504, this.wmqSenderChannel.getShortRetryInterval());
        pcfCmd.addParameter(1507, this.wmqSenderChannel.getLongRetryCount());
        pcfCmd.addParameter(1506, this.wmqSenderChannel.getLongRetryInterval());
        if (WmqChannelMonitoring.HIGH == this.wmqSenderChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 65);
        } else if (WmqChannelMonitoring.LOW == this.wmqSenderChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 17);
        } else if (WmqChannelMonitoring.MEDIUM == this.wmqSenderChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 33);
        } else if (WmqChannelMonitoring.OFF == this.wmqSenderChannel.getChannelMonitoring()) {
            pcfCmd.addParameter(122, 0);
        } else {
            pcfCmd.addParameter(122, -3);
        }
        if (WmqChannelStatisticTypes.HIGH == this.wmqSenderChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 65);
        } else if (WmqChannelStatisticTypes.LOW == this.wmqSenderChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 17);
        } else if (WmqChannelStatisticTypes.MEDIUM == this.wmqSenderChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 33);
        } else if (WmqChannelStatisticTypes.OFF == this.wmqSenderChannel.getChannelStatistics()) {
            pcfCmd.addParameter(129, 0);
        } else {
            pcfCmd.addParameter(129, -3);
        }
        if (this.wmqSenderChannel.getSslCipherSpecification() != null) {
            pcfCmd.addParameter(3544, this.wmqSenderChannel.getSslCipherSpecification().toString());
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating SenderChannel \"" + this.wmqSenderChannel.getChannelName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating SenderChannel Step";
    }

    protected String getSuccessMessage() {
        return "The SenderChannel \"" + this.wmqSenderChannel.getChannelName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

