/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqTCPListener;
import com.xebialabs.deployit.plugin.wmq.enums.WmqListenerControl;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;

public class CreateWmqTCPListenerStep
extends BaseWmqStep {
    public WmqTCPListener wmqListener;

    public CreateWmqTCPListenerStep(WmqTCPListener wmqListener, WmqQueueManager wmqQmanager) {
        this.wmqListener = wmqListener;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        this.mqCommand = 95;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        pcfCmd.addParameter(3554, this.wmqListener.getListenerName());
        pcfCmd.addParameter(1501, 2);
        pcfCmd.addParameter(3552, this.wmqListener.getIpAddress());
        pcfCmd.addParameter(1602, this.wmqListener.getBacklog());
        pcfCmd.addParameter(1522, this.wmqListener.getPort());
        pcfCmd.addParameter(3555, this.wmqListener.getDescription());
        if (WmqListenerControl.MANUAL == this.wmqListener.getControl()) {
            pcfCmd.addParameter(1601, 2);
        } else if (WmqListenerControl.QUEUE_MANAGER == this.wmqListener.getControl()) {
            pcfCmd.addParameter(1601, 0);
        } else if (WmqListenerControl.QUEUE_MANAGER_START == this.wmqListener.getControl()) {
            pcfCmd.addParameter(1601, 1);
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating TCPListener \"" + this.wmqListener.getListenerName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating TCPListener Step";
    }

    protected String getSuccessMessage() {
        return "The TCPListener \"" + this.wmqListener.getListenerName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

