/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqTCPListener;
import com.xebialabs.deployit.plugin.wmq.enums.WmqListenerControl;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.MQPluginException;

public class InquireWmqTCPListenerStep
extends BaseWmqStep {
    private WmqTCPListener wmqTCPListener;

    protected void init() {
        this.mqCommand = 97;
    }

    public InquireWmqTCPListenerStep(WmqTCPListener wmqTCPListener, WmqQueueManager wmqQmanager) {
        this.wmqTCPListener = wmqTCPListener;
        this.wmqQmanager = wmqQmanager;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) throws MQPluginException {
        pcfCmd.addParameter(3554, this.wmqTCPListener.getListenerName());
        pcfCmd.addFilterParameter(1501, 2, 2);
        int[] parameters = new int[]{1009};
        pcfCmd.addParameter(1222, parameters);
    }

    protected void readPCFMessageResponse(StepExecutionContext ctx, PCFMessage pcfMessage) {
        if (pcfMessage != null) {
            this.wmqTCPListener.setBacklog((Integer)pcfMessage.getParameterValue(1602));
            if ((Integer)pcfMessage.getParameterValue(1601) == 2) {
                this.wmqTCPListener.setControl(WmqListenerControl.MANUAL);
            } else if ((Integer)pcfMessage.getParameterValue(1601) == 0) {
                this.wmqTCPListener.setControl(WmqListenerControl.QUEUE_MANAGER);
            } else if ((Integer)pcfMessage.getParameterValue(1601) == 1) {
                this.wmqTCPListener.setControl(WmqListenerControl.QUEUE_MANAGER_START);
            }
            this.wmqTCPListener.setIpAddress(((String)pcfMessage.getParameterValue(3552)).trim());
            this.wmqTCPListener.setDescription(((String)pcfMessage.getParameterValue(3555)).trim());
            this.wmqTCPListener.setPort((Integer)pcfMessage.getParameterValue(1522));
            ctx.logOutput("Operation Successfull");
            ctx.logOutput("The Listener \"" + this.wmqTCPListener.getListenerName() + "\" is inquired successfully");
        } else {
            ctx.logOutput("Response is null");
        }
    }

    public String getDescription() {
        return "Inquiring the TCP Listener \"" + this.wmqTCPListener.getListenerName() + "\" for Queue Manager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }

    protected String getSuccessMessage() {
        return null;
    }
}

