/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFException;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqChannel;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;
import com.xebialabs.deployit.plugin.wmq.utils.PCF_CommonMethods;
import com.xebialabs.deployit.plugin.wmq.utils.WmqHelper;

public class StopWmqChannelStep
extends BaseWmqStep {
    private WmqChannel channel;

    public StopWmqChannelStep(WmqChannel channel, WmqQueueManager wmqQmanager) {
        this.channel = channel;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        this.mqCommand = 29;
    }

    public boolean execute(StepExecutionContext ctx) {
        this.init();
        PCF_CommonMethods pcfCM = new PCF_CommonMethods();
        try {
            WmqHelper.createAgent(this.wmqQmanager, pcfCM, ctx);
            PCFMessage pcfCmd = new PCFMessage(this.mqCommand);
            this.setPCFMessageParameters(pcfCmd);
            PCFMessage pcfMessage = WmqHelper.sendPcfcmCommand(pcfCM, pcfCmd);
            this.readPCFMessageResponse(ctx, pcfMessage);
            pcfCM.destroyAgent();
        }
        catch (Exception e) {
            if (e.getClass().equals(PCFException.class)) {
                PCFException pcfe = (PCFException)e;
                if (pcfe.reasonCode == 3008 || pcfe.reasonCode == 4064 || pcfe.reasonCode == 4029) {
                    ctx.logOutput("Warning: Command Failed to stop the channel but continue step with delete");
                    return true;
                }
            }
            pcfCM.displayException(e, ctx);
            return false;
        }
        return true;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        pcfCmd.addParameter(3501, this.channel.getChannelName());
    }

    public String getDescription() {
        return "Stopping the Channel \"" + this.channel.getChannelName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }

    protected String getSuccessMessage() {
        return "The Channel  \"" + this.channel.getChannelName() + "\" stopped successfully on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

