/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.ci;

import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDefaultBindType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqScope;

@SuppressWarnings("serial")
public abstract class WmqBaseRemoteQueue extends WmqQueue {

	@ConfigurationItemProperty(label = "Remote queue", description = "Name of remote queue as known locally on the remote queue manager.")
	private String remoteQueue;

	@ConfigurationItemProperty(label = "Remote queue manager", description = "Name of local definition of a remote queue, RemoteQMgrName  must not be blank or the name of the connected queue manager.")
	private String remoteQueueManager;

	@ConfigurationItemProperty(label = "Cluster Name", description = "Name of the Cluster.Only one value should be mentioned among ClusterName and ClusterNamelist  ", category = "Cluster")
	private String clusterName;

	@ConfigurationItemProperty(label = "Cluster Namelist", description = "Name of the Cluster Namelist.Only one value should be mentioned among ClusterName and ClusterNamelist ", category = "Cluster")
	private String clusterNamelist;

	@ConfigurationItemProperty(label = "Scope", description = "We can specify the scope of the queue either Cell or Queuemanager.")
	private WmqScope scope;

	@ConfigurationItemProperty(label = "XmitQueue", description = "Transmission queue name.")
	private String transmissionQueue;

	@ConfigurationItemProperty(label = "Default Bind Type", description = "This parameter specifies the binding to be used when MQOO_BIND_AS_Q_DEF is specified on the MQOPEN call.", category = "Cluster")
	private WmqDefaultBindType defaultBindType;

	@ConfigurationItemProperty(label = "CLWL queue rank", description = "This parameter specifies the rank of the queue in cluster workload management in the range 0 to 9.", category = "Cluster")
	private int clwlQueueRank;

	@ConfigurationItemProperty(label = "CLWL queue priority", description = "This parameter specifies the priority of the queue in cluster workload management in the range 0 to 9.", category = "Cluster")
	private int clwlQueuePriority;

	public WmqDefaultBindType getDefaultBindType() {
		return defaultBindType;
	}

	public void setDefaultBindType(WmqDefaultBindType defaultBindType) {
		this.defaultBindType = defaultBindType;
	}

	public String getTransmissionQueue() {
		return transmissionQueue;
	}

	public int getClwlQueueRank() {
		return clwlQueueRank;
	}

	public void setClwlQueueRank(int clwlQueueRank) {
		this.clwlQueueRank = clwlQueueRank;
	}

	public int getClwlQueuePriority() {
		return clwlQueuePriority;
	}

	public void setClwlQueuePriority(int clwlQueuePriority) {
		this.clwlQueuePriority = clwlQueuePriority;
	}

	public void setTransmissionQueue(String transmissionQueue) {
		this.transmissionQueue = transmissionQueue;
	}

	public WmqScope getScope() {
		return scope;
	}

	public void setScope(WmqScope scope) {
		this.scope = scope;
	}

	public String getClusterName() {
		return clusterName;
	}

	public void setClusterName(String clusterName) {
		this.clusterName = clusterName;
	}

	public String getClusterNamelist() {
		return clusterNamelist;
	}

	public void setClusterNamelist(String clusterNamelist) {
		this.clusterNamelist = clusterNamelist;

	}

	public String getRemoteQueue() {
		return remoteQueue;
	}

	public void setRemoteQueue(String remoteQueue) {
		this.remoteQueue = remoteQueue;
	}

	public String getRemoteQueueManager() {
		return remoteQueueManager;
	}

	public void setRemoteQueueManager(String remoteQueueManager) {
		this.remoteQueueManager = remoteQueueManager;
	}

}
