/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqClusterSenderChannel;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMCAType;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelMonitoring;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelPropertyControl;
import com.xebialabs.deployit.plugin.wmq.enums.WmqChannelStatisticTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDataConversion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqHeaderCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqMessageCompression;
import com.xebialabs.deployit.plugin.wmq.enums.WmqNonpersistentMessageSpeed;
import com.xebialabs.deployit.plugin.wmq.enums.WmqTransmissionProtocolTypes;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.utils.StringUtils;

/**
 * Creates a {@link WmqClusterSenderChannel} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqClusterSenderChannelStep extends BaseWmqStep {

	public WmqClusterSenderChannel wmqClusterSenderChannel;
	private int[] messageCompressionList = new int[1];

	public CreateWmqClusterSenderChannelStep(WmqClusterSenderChannel wmqClusterSenderChannel, WmqQueueManager wmqQmanager)

	{

		this.wmqClusterSenderChannel = wmqClusterSenderChannel;
		this.wmqQmanager = wmqQmanager;
	}

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_CREATE_CHANNEL;

	}

	@Override
	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// Setting MQ ClusterSenderChannel ChannelName
		pcfCmd.addParameter(MQConstants.MQCACH_CHANNEL_NAME, wmqClusterSenderChannel.getChannelName());

		// Setting MQ ClusterSenderChannel ChannelType
		pcfCmd.addParameter(MQConstants.MQIACH_CHANNEL_TYPE, MQConstants.MQCHT_CLUSSDR);

		// Setting MQ ClusterSenderChannel Channel Description
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getDescription())) {

			pcfCmd.addParameter(MQConstants.MQCACH_DESC, wmqClusterSenderChannel.getDescription());
		}

		// Setting MQ ClusterSenderChannel Transport Type
		if (WmqTransmissionProtocolTypes.LU6 == wmqClusterSenderChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_LU62);
		} else if (WmqTransmissionProtocolTypes.NET_BIOS == wmqClusterSenderChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_NETBIOS);
		} else if (WmqTransmissionProtocolTypes.SPX == wmqClusterSenderChannel.getTransportType()) {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_SPX);
		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_TCP);
		}

		// Setting MQ ClusterSenderChannel Connection name
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getConnectionName())) {

			pcfCmd.addParameter(MQConstants.MQCACH_CONNECTION_NAME, wmqClusterSenderChannel.getConnectionName());
		}

		// Setting MQ ClusterSenderChannel Local communications address
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getLocalCommunicationAddress())) {

			pcfCmd.addParameter(MQConstants.MQCACH_LOCAL_ADDRESS, wmqClusterSenderChannel.getLocalCommunicationAddress());
		}

		// Setting MQ ClusterSenderChannel HeaderCompression value
		if (WmqHeaderCompression.SYSTEM == wmqClusterSenderChannel.getHeaderCompression()) {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_SYSTEM;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		} else {
			int[] list = new int[1];
			list[0] = MQConstants.MQCOMPRESS_NONE;

			pcfCmd.addParameter(MQConstants.MQIACH_HDR_COMPRESSION, list);
		}

		// Setting MQ ClusterSenderChannel KeepaliveInterval
		if (wmqClusterSenderChannel.getKeepAliveInterval() > -1 && wmqClusterSenderChannel.getKeepAliveInterval() <= 99999) {
			pcfCmd.addParameter(MQConstants.MQIACH_KEEP_ALIVE_INTERVAL, wmqClusterSenderChannel.getKeepAliveInterval());
		}

		// Setting MQ ClusterSenderChannel HeartbeatInterval
		pcfCmd.addParameter(MQConstants.MQIACH_HB_INTERVAL, wmqClusterSenderChannel.getHeartBeatInterval());

		// Setting MQ ClusterSenderChannel MaximumMessageLength
		pcfCmd.addParameter(MQConstants.MQIACH_MAX_MSG_LENGTH, wmqClusterSenderChannel.getMaximumMessageLength());

		// Setting MQ ClusterSenderChannel SequenceNumberWrap
		if (wmqClusterSenderChannel.getSequenceNumberWrap() < 100) {
			pcfCmd.addParameter(MQConstants.MQIACH_SEQUENCE_NUMBER_WRAP, 999999999);
		} else if (wmqClusterSenderChannel.getSequenceNumberWrap() != 0) {

			pcfCmd.addParameter(MQConstants.MQIACH_SEQUENCE_NUMBER_WRAP, wmqClusterSenderChannel.getSequenceNumberWrap());
		}

		// Setting MQ ClusterSenderChannel MessageCompression Value
		if (WmqMessageCompression.RLE == wmqClusterSenderChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_RLE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqMessageCompression.ZLIBFAST == wmqClusterSenderChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBFAST;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);

		} else if (WmqMessageCompression.ZLIBHIGH == wmqClusterSenderChannel.getMessageCompression()) {

			messageCompressionList[0] = MQConstants.MQCOMPRESS_ZLIBHIGH;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		} else {
			messageCompressionList[0] = MQConstants.MQCOMPRESS_NONE;
			pcfCmd.addParameter(MQConstants.MQIACH_MSG_COMPRESSION, messageCompressionList);
		}

		// Setting MQ ClusterSenderChannel NonPersistentMessageSpeed
		if (WmqNonpersistentMessageSpeed.NORMAL == wmqClusterSenderChannel.getNonPersistentMessageSpeed()) {

			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_NORMAL);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_NPM_SPEED, MQConstants.MQNPMS_FAST);
		}

		// Setting MQ ClusterSenderChannel BatchSize
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_SIZE, wmqClusterSenderChannel.getBatchSize());

		// Setting MQ ClusterSenderChannel BatchInterval
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_INTERVAL, wmqClusterSenderChannel.getBatchInterval());

		// Setting MQ ClusterSenderChannel DisconnectInterval
		pcfCmd.addParameter(MQConstants.MQIACH_DISC_INTERVAL, wmqClusterSenderChannel.getDisconnectInterval());

		// Setting MQ ClusterSenderChannel DataConversion value
		if (WmqDataConversion.CONVERSION == wmqClusterSenderChannel.getDataConversion()) {

			pcfCmd.addParameter(MQConstants.MQIACH_DATA_CONVERSION, MQConstants.MQCDC_SENDER_CONVERSION);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_DATA_CONVERSION, MQConstants.MQCDC_NO_SENDER_CONVERSION);
		}

		// Setting MQ ClusterSenderChannel BatchHeartBeatInterval
		pcfCmd.addParameter(MQConstants.MQIACH_BATCH_HB, wmqClusterSenderChannel.getBatchHeartBeatInterval());

		if (wmqQmanager.getVersion() != WmqVersion.WMQ_60) {
			// Setting MQ ClusterSenderChannel PropertyControl
			if (WmqChannelPropertyControl.ALL == wmqClusterSenderChannel.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_ALL);

			} else if (WmqChannelPropertyControl.NONE == wmqClusterSenderChannel.getPropertyControl()) {

				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_NONE);

			} else {
				pcfCmd.addParameter(MQConstants.MQIA_PROPERTY_CONTROL, MQConstants.MQPROP_COMPATIBILITY);
			}
		}

		// Setting MQ ClusterSenderChannel ClusterName
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getClusterName())) {

			pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_NAME, wmqClusterSenderChannel.getClusterName());

		}

		// Setting MQ ClusterSenderChannel ClusterNamelist
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getClusterNamelist())) {

			pcfCmd.addParameter(MQConstants.MQCA_CLUSTER_NAMELIST, wmqClusterSenderChannel.getClusterNamelist());

		}

		// Setting MQ ClusterSenderChannel Channel rank for the purposes of
		// cluster workload distribution
		pcfCmd.addParameter(MQConstants.MQIACH_CLWL_CHANNEL_RANK, wmqClusterSenderChannel.getClusterWorkloadChannelRank());

		// Setting MQ ClusterSenderChannel Channel priority
		pcfCmd.addParameter(MQConstants.MQIACH_CLWL_CHANNEL_PRIORITY, wmqClusterSenderChannel.getClusterWorkloadChannelPriority());

		// Setting MQ ClusterSenderChannel Channel weighting
		pcfCmd.addParameter(MQConstants.MQIACH_CLWL_CHANNEL_WEIGHT, wmqClusterSenderChannel.getClusterWorkloadChannelWeight());

		// Setting MQ ClusterSenderChannel MCAUserID
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getMcaUserID())) {

			pcfCmd.addParameter(MQConstants.MQCACH_MCA_USER_ID, wmqClusterSenderChannel.getMcaUserID());

		}

		// Setting MQ ClusterSenderChannel MCAType
		if (WmqChannelMCAType.THREAD == wmqClusterSenderChannel.getMcaType()) {

			pcfCmd.addParameter(MQConstants.MQIACH_MCA_TYPE, MQConstants.MQMCAT_THREAD);

		} else {
			pcfCmd.addParameter(MQConstants.MQIACH_MCA_TYPE, MQConstants.MQMCAT_PROCESS);
		}

		// Setting MQ ClusterSenderChannel SendExitname
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getSendExit())) {

			String[] sendExitList = StringUtils.split(wmqClusterSenderChannel.getSendExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_NAME, sendExitList);

		}

		// Setting MQ ClusterSenderChannel SendExitUserData
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getSendExitUserData())) {

			String[] sendExitUserDataList = StringUtils.split(wmqClusterSenderChannel.getSendExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_SEND_EXIT_USER_DATA, sendExitUserDataList);
		}

		// Setting MQ ClusterSenderChannel ReceiveExit
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getReceiveExit())) {

			String[] receiveExitList = StringUtils.split(wmqClusterSenderChannel.getReceiveExit(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_NAME, receiveExitList);
		}

		// Setting MQ ClusterSenderChannel ReceiveUserData
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getReceiveExitUserData())) {

			String[] receiveExitUserDataList = StringUtils.split(wmqClusterSenderChannel.getReceiveExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_RCV_EXIT_USER_DATA, receiveExitUserDataList);
		}

		// Setting MQ ClusterSenderChannel SecurityExit
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getSecurityExit())) {
			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_NAME, wmqClusterSenderChannel.getSecurityExit());
		}

		// Setting MQ ClusterSenderChannel SecurityUserData
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getSecurityExitUserData())) {

			pcfCmd.addParameter(MQConstants.MQCACH_SEC_EXIT_USER_DATA, wmqClusterSenderChannel.getSecurityExitUserData());
		}

		// Setting MQ ClusterSenderChannel MsgExit
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getMessageExitName())) {

			String[] messageExitList = StringUtils.split(wmqClusterSenderChannel.getMessageExitName(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_NAME, messageExitList);
		}

		// Setting MQ ClusterSenderChannel MsgExitUserData
		if (StringUtils.isNotBlank(wmqClusterSenderChannel.getMessageExitUserData())) {

			String[] messageExitUserList = StringUtils.split(wmqClusterSenderChannel.getMessageExitUserData(), ",");
			pcfCmd.addParameter(MQConstants.MQCACH_MSG_EXIT_USER_DATA, messageExitUserList);
		}

		// Setting MQ ClusterSenderChannel ShortRetryCount
		pcfCmd.addParameter(MQConstants.MQIACH_SHORT_RETRY, wmqClusterSenderChannel.getShortRetryCount());

		// Setting MQ ClusterSenderChannel ShortRetryInterval
		pcfCmd.addParameter(MQConstants.MQIACH_SHORT_TIMER, wmqClusterSenderChannel.getShortRetryInterval());

		// Setting MQ ClusterSenderChannel LongRetryCount
		pcfCmd.addParameter(MQConstants.MQIACH_LONG_RETRY, wmqClusterSenderChannel.getLongRetryCount());

		// Setting MQ ClusterSenderChannel LongRetryInterval
		pcfCmd.addParameter(MQConstants.MQIACH_LONG_TIMER, wmqClusterSenderChannel.getLongRetryInterval());

		// Setting MQ ClusterSenderChannel Monitoring
		if (WmqChannelMonitoring.HIGH == wmqClusterSenderChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelMonitoring.LOW == wmqClusterSenderChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelMonitoring.MEDIUM == wmqClusterSenderChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelMonitoring.OFF == wmqClusterSenderChannel.getChannelMonitoring()) {

			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_MONITORING_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ ClusterSenderChannel Statistics
		if (WmqChannelStatisticTypes.HIGH == wmqClusterSenderChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_HIGH);

		} else if (WmqChannelStatisticTypes.LOW == wmqClusterSenderChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_LOW);

		} else if (WmqChannelStatisticTypes.MEDIUM == wmqClusterSenderChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_MEDIUM);

		} else if (WmqChannelStatisticTypes.OFF == wmqClusterSenderChannel.getChannelStatistics()) {

			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_OFF);

		} else {
			pcfCmd.addParameter(MQConstants.MQIA_STATISTICS_CHANNEL, MQConstants.MQMON_Q_MGR);
		}

		// Setting MQ ClusterSenderChannel SSLCipherSpec
		if (wmqClusterSenderChannel.getSslCipherSpecification() != null) {

			pcfCmd.addParameter(MQConstants.MQCACH_SSL_CIPHER_SPEC, wmqClusterSenderChannel.getSslCipherSpecification().toString());
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating ClusterSenderChannel \"" + wmqClusterSenderChannel.getChannelName() + "\" on QueueManager \""
			        + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Creating ClusterSenderChannel Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The ClusterSenderChannel \"" + wmqClusterSenderChannel.getChannelName() + "\" is created on QueueManager \""
		        + this.wmqQmanager.getQueueManagerName() + "\"";

	}

}
