/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.utils;

import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.pcf.PCFException;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.PCF_CommonMethods;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WmqHelper {
    public static Map priorityMap = new HashMap();

    public static final void createAgent(WmqQueueManager wmqQManager, PCF_CommonMethods pcfCommonMethods, StepExecutionContext ctx) throws MQDataException {
        pcfCommonMethods.setQueueManager(wmqQManager.getQueueManagerName());
        if (wmqQManager.getHostName().getAddress() != null) {
            pcfCommonMethods.setHost(wmqQManager.getHostName().getAddress());
        }
        if (wmqQManager.getPortNumber() != 0) {
            pcfCommonMethods.setPort(wmqQManager.getPortNumber());
        }
        if (wmqQManager.getChannelName() != null) {
            pcfCommonMethods.setChannel(wmqQManager.getChannelName());
        }
        pcfCommonMethods.createAgent(4);
    }

    public static final PCFMessage sendPcfcmCommand(PCF_CommonMethods pcfCM, PCFMessage pcfCmd) throws PCFException, MQDataException, IOException {
        PCFMessage[] pcfResponse = WmqHelper.sendPcfcmCommandToAgent(pcfCM, pcfCmd);
        PCFMessage pcfMessage = pcfResponse[0];
        return pcfMessage;
    }

    public static final PCFMessage[] sendPcfcmCommandToAgent(PCF_CommonMethods pcfCM, PCFMessage pcfCmd) throws PCFException, MQDataException, IOException {
        PCFMessage[] pcfResponse = pcfCM.agent.send(pcfCmd);
        return pcfResponse;
    }

    public static int getSubscriptionPriority(String priority) {
        int priorityValue = -3;
        Integer priValue = (Integer)priorityMap.get(priority);
        if (priValue != null) {
            priorityValue = priValue;
        }
        return priorityValue;
    }

    public static String convertArrayToString(Object obj) {
        if (obj instanceof String) {
            return obj.toString().trim();
        }
        String[] arrayData = null;
        if (obj instanceof String[]) {
            arrayData = (String[])obj;
        }
        String responseData = "";
        boolean firstTime = true;
        if (arrayData != null) {
            for (String string : arrayData) {
                responseData = firstTime ? string.trim() : responseData + "," + string.trim();
                firstTime = false;
            }
        }
        return responseData;
    }

    static {
        priorityMap.put("AsPublished", -1);
        priorityMap.put("ASQueueDefined", -3);
        priorityMap.put("Zero", 0);
        priorityMap.put("One", 1);
        priorityMap.put("Two", 2);
        priorityMap.put("Three", 3);
        priorityMap.put("Four", 4);
        priorityMap.put("Five", 5);
        priorityMap.put("Six", 6);
        priorityMap.put("Seven", 7);
        priorityMap.put("Eight", 8);
        priorityMap.put("Nine", 9);
    }
}

