/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import static org.apache.commons.lang.StringUtils.join;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.utils.RegexUtils;

/**
 * Retrieves the names of the {@link WmqQueueManager} which are already exist on the Host.
 */
@SuppressWarnings("serial")
public class CheckWmqQueueManagerNameStep implements Step {

	private WmqQueueManager wmqQueueManager;

	public CheckWmqQueueManagerNameStep(WmqQueueManager wmqQueueManager) {
		this.wmqQueueManager = wmqQueueManager;
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession hostSession = wmqQueueManager.getHostName().getHostSession();
		List<String> list = new ArrayList<String>();
		try {
			CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
			List<String> cmd = new ArrayList<String>();
			cmd.add("dspmq");
			String[] cmdArray = cmd.toArray(new String[cmd.size()]);
			int res = hostSession.execute(capturedOutput, cmdArray);
			if (res != 0) {
				ctx.logError("Non-zero exitcode from " + join(cmdArray, " ") + ": " + res);
				return false;
			}

			for (String eachLine : capturedOutput.getOutputLines()) {
				if (eachLine.startsWith("QMNAME")) {
					String[] matches = RegexUtils.regexMatch(eachLine, "QMNAME\\((\\S+)\\)[\\s\\S]*");
					if (matches != null && matches.length == 1) {
						String wmqQManagerName = matches[0];
						if (wmqQManagerName.equalsIgnoreCase(wmqQueueManager.getQueueManagerName())) {
							ctx.logOutput("Check QueueManager Name Step succeeded");
							return true;
						}
						list.add(wmqQManagerName);
					}

				}
			}
		} finally {
			hostSession.close();
		}
		ctx.logError("Queue Manager Name \"" + wmqQueueManager.getQueueManagerName() + "\" is not available");
		if (list.size() > 0) {
			ctx.logOutput("Available Queue Manager Names on the Host \"" + wmqQueueManager.getHostName() + "\" " + list);
		}
		return false;
	}

	public String getDescription() {

		return "Check QueueManager Name Step";
	}
}