/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqSubscriptions;
import com.xebialabs.deployit.plugin.wmq.enums.WmqDestinationClass;
import com.xebialabs.deployit.plugin.wmq.enums.WmqProperties;
import com.xebialabs.deployit.plugin.wmq.enums.WmqSScope;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVariableUserId;
import com.xebialabs.deployit.plugin.wmq.enums.WmqVersion;
import com.xebialabs.deployit.plugin.wmq.enums.WmqWildCardUsage;
import com.xebialabs.deployit.plugin.wmq.utils.WmqHelper;

/**
 * Creates a {@link WmqSubscriptions} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqSubscriptionStep extends BaseWmqStep {

	public WmqSubscriptions wmqSubscriptions;

	public CreateWmqSubscriptionStep(WmqSubscriptions wmqSubscriptions, WmqQueueManager wmqQmanager) {

		this.wmqSubscriptions = wmqSubscriptions;
		this.wmqQmanager = wmqQmanager;

	}

	@Override
	protected void init() {
		if (wmqQmanager.getVersion() == WmqVersion.WMQ_60) {

			throw new ResolutionException("Subscription is not supported in MQV6");
		}
		this.mqCommand = MQConstants.MQCMD_CREATE_SUBSCRIPTION;

	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// Subscription name - Mandatory
		pcfCmd.addParameter(MQConstants.MQCACF_SUB_NAME, wmqSubscriptions.getSubscriptionName());

		// topic name - Mandatory.
		pcfCmd.addParameter(MQConstants.MQCA_TOPIC_NAME, wmqSubscriptions.getTopicName());

		// Topic String - Mandatory.
		pcfCmd.addParameter(MQConstants.MQCA_TOPIC_STRING, wmqSubscriptions.getTopicString());

		if (WmqDestinationClass.PROVIDED == wmqSubscriptions.getDestinationClass()) {

			// DestinationQueueManagerName Type - Mandatory.
			pcfCmd.addParameter(MQConstants.MQCACF_DESTINATION_Q_MGR, wmqSubscriptions.getDestinationQueueManager());

			// DestinationQueueName Type - Mandatory
			pcfCmd.addParameter(MQConstants.MQCACF_DESTINATION, wmqSubscriptions.getDestinationName());
		}

		// Scope - optional
		if (WmqSScope.QUEUE_MANAGER == wmqSubscriptions.getScope()) {
			pcfCmd.addParameter(MQConstants.MQIACF_SUBSCRIPTION_SCOPE, MQConstants.MQTSCOPE_QMGR);
		} else if (WmqSScope.ALL == wmqSubscriptions.getScope()) {
			pcfCmd.addParameter(MQConstants.MQIACF_SUBSCRIPTION_SCOPE, MQConstants.MQTSCOPE_ALL);
		}

		// DestinationClass - optional

		if (WmqDestinationClass.PROVIDED == wmqSubscriptions.getDestinationClass()) {
			pcfCmd.addParameter(MQConstants.MQIACF_DESTINATION_CLASS, MQConstants.MQDC_PROVIDED);

		} else if (WmqDestinationClass.MANAGED == wmqSubscriptions.getDestinationClass()) {

			pcfCmd.addParameter(MQConstants.MQIACF_DESTINATION_CLASS, MQConstants.MQDC_MANAGED);
		}

		// Properties - optional

		if (WmqProperties.COMPATABILITY == wmqSubscriptions.getProperties()) {

			pcfCmd.addParameter(MQConstants.MQIACF_PUBSUB_PROPERTIES, MQConstants.MQPSPROP_COMPAT);

		} else if (WmqProperties.NONE == wmqSubscriptions.getProperties()) {

			pcfCmd.addParameter(MQConstants.MQIACF_PUBSUB_PROPERTIES, MQConstants.MQPSPROP_NONE);
		} else if (WmqProperties.RFH2 == wmqSubscriptions.getProperties()) {

			pcfCmd.addParameter(MQConstants.MQIACF_PUBSUB_PROPERTIES, MQConstants.MQPSPROP_RFH2);
		}

		// Selector - optional

		pcfCmd.addParameter(MQConstants.MQCACF_SUB_SELECTOR, wmqSubscriptions.getSelector());

		// VariableUserId - optional

		if (WmqVariableUserId.ANY == wmqSubscriptions.getVariableUserId()) {
			pcfCmd.addParameter(MQConstants.MQIACF_VARIABLE_USER_ID, MQConstants.MQVU_ANY_USER);

		} else if (WmqVariableUserId.FIXED == wmqSubscriptions.getVariableUserId()) {

			pcfCmd.addParameter(MQConstants.MQIACF_VARIABLE_USER_ID, MQConstants.MQVU_FIXED_USER);
		}

		// UserData - optional

		pcfCmd.addParameter(MQConstants.MQCACF_SUB_USER_DATA, wmqSubscriptions.getUserData());

		// ApplicationIdentity - optional

		pcfCmd.addParameter(MQConstants.MQCACF_APPL_IDENTITY_DATA, wmqSubscriptions.getApplicationIdentity());

		// PublishPriority - optional

		setPriorityValue(pcfCmd);

		// WildCardUsage - optional

		if (WmqWildCardUsage.TOPIC_LEVEL_WILDCARD == wmqSubscriptions.getWildCardUsage()) {
			pcfCmd.addParameter(MQConstants.MQIACF_WILDCARD_SCHEMA, MQConstants.MQWS_TOPIC);

		} else if (WmqWildCardUsage.CHARACTER_LEVEL_WILDCARD == wmqSubscriptions.getWildCardUsage()) {

			pcfCmd.addParameter(MQConstants.MQIACF_WILDCARD_SCHEMA, MQConstants.MQWS_CHAR);
		}

		// SubscriptionLevel - optional
		pcfCmd.addParameter(MQConstants.MQIACF_SUB_LEVEL, wmqSubscriptions.getSubscriptionLevel());

		// expiryLevel - optional
		if (wmqSubscriptions.getExpiry() != 0) {
			pcfCmd.addParameter(MQConstants.MQIACF_EXPIRY, wmqSubscriptions.getExpiry());

		}

	}

	private void setPriorityValue(PCFMessage pcfCmd) {

		if (wmqSubscriptions.getPublishPriority() != null) {
			int priorityValue = WmqHelper.getSubscriptionPriority(wmqSubscriptions.getPublishPriority().toString());
			pcfCmd.addParameter(MQConstants.MQIACF_PUB_PRIORITY, priorityValue);
		} else {
			pcfCmd.addParameter(MQConstants.MQIACF_PUB_PRIORITY, MQConstants.MQPRI_PRIORITY_AS_PUBLISHED);
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating Subscription \"" + wmqSubscriptions.getSubscriptionName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName()
			        + "\"";
		}
		return "Creating Subscription Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The Subscription \"" + wmqSubscriptions.getSubscriptionName() + "\" is created on QueueManager\"" + this.wmqQmanager.getQueueManagerName()
		        + "\"";

	}
}
