/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.constants.MQConstants;
import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqTCPListener;
import com.xebialabs.deployit.plugin.wmq.enums.WmqListenerControl;

/**
 * Creates a {@link WmqTCPListener} in a {@link WmqQueueManager}
 */
@SuppressWarnings("serial")
public class CreateWmqTCPListenerStep extends BaseWmqStep {

	public WmqTCPListener wmqListener;

	public CreateWmqTCPListenerStep(WmqTCPListener wmqListener, WmqQueueManager wmqQmanager) {

		this.wmqListener = wmqListener;
		this.wmqQmanager = wmqQmanager;
	}

	@Override
	protected void init() {
		this.mqCommand = MQConstants.MQCMD_CREATE_LISTENER;

	}

	public void setPCFMessageParameters(PCFMessage pcfCmd) {

		// ListenerName - Mandatory.
		pcfCmd.addParameter(MQConstants.MQCACH_LISTENER_NAME, wmqListener.getListenerName());

		// Listener protocolType - Mandatory
		pcfCmd.addParameter(MQConstants.MQIACH_XMIT_PROTOCOL_TYPE, MQConstants.MQXPT_TCP);
		// IpAddress -optional
		pcfCmd.addParameter(MQConstants.MQCACH_IP_ADDRESS, wmqListener.getIpAddress());
		// Backlog -optional
		pcfCmd.addParameter(MQConstants.MQIACH_BACKLOG, wmqListener.getBacklog());
		// Port -optional
		pcfCmd.addParameter(MQConstants.MQIACH_PORT, wmqListener.getPort());
		// Description -optional
		pcfCmd.addParameter(MQConstants.MQCACH_LISTENER_DESC, wmqListener.getDescription());

		// Control -optional
		if (WmqListenerControl.MANUAL == wmqListener.getControl()) {
			pcfCmd.addParameter(MQConstants.MQIACH_LISTENER_CONTROL, MQConstants.MQSVC_CONTROL_MANUAL);

		} else if (WmqListenerControl.QUEUE_MANAGER == wmqListener.getControl()) {

			pcfCmd.addParameter(MQConstants.MQIACH_LISTENER_CONTROL, MQConstants.MQSVC_CONTROL_Q_MGR);
		} else if (WmqListenerControl.QUEUE_MANAGER_START == wmqListener.getControl()) {

			pcfCmd.addParameter(MQConstants.MQIACH_LISTENER_CONTROL, MQConstants.MQSVC_CONTROL_Q_MGR_START);
		}

	}

	public String getDescription() {

		if (this.wmqQmanager.getQueueManagerName() != null) {
			return "Creating TCPListener \"" + wmqListener.getListenerName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
		}
		return "Creating TCPListener Step";
	}

	@Override
	protected String getSuccessMessage() {

		return "The TCPListener \"" + wmqListener.getListenerName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";

	}

}
