/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wmq.step;

import com.ibm.mq.headers.pcf.PCFMessage;
import com.xebialabs.deployit.plugin.wmq.ci.WmqQueueManager;
import com.xebialabs.deployit.plugin.wmq.ci.WmqSPXListener;
import com.xebialabs.deployit.plugin.wmq.enums.WmqListenerControl;
import com.xebialabs.deployit.plugin.wmq.step.BaseWmqStep;

public class CreateWmqSPXListenerStep
extends BaseWmqStep {
    public WmqSPXListener wmqSpxListener;

    public CreateWmqSPXListenerStep(WmqSPXListener wmqSpxListener, WmqQueueManager wmqQmanager) {
        this.wmqSpxListener = wmqSpxListener;
        this.wmqQmanager = wmqQmanager;
    }

    protected void init() {
        this.mqCommand = 95;
    }

    public void setPCFMessageParameters(PCFMessage pcfCmd) {
        pcfCmd.addParameter(3554, this.wmqSpxListener.getListenerName());
        pcfCmd.addParameter(1501, 4);
        pcfCmd.addParameter(1602, this.wmqSpxListener.getBacklog());
        pcfCmd.addParameter(1521, this.wmqSpxListener.getSocket());
        pcfCmd.addParameter(3555, this.wmqSpxListener.getDescription());
        if (WmqListenerControl.MANUAL == this.wmqSpxListener.getControl()) {
            pcfCmd.addParameter(1601, 2);
        } else if (WmqListenerControl.QUEUE_MANAGER == this.wmqSpxListener.getControl()) {
            pcfCmd.addParameter(1601, 0);
        } else if (WmqListenerControl.QUEUE_MANAGER_START == this.wmqSpxListener.getControl()) {
            pcfCmd.addParameter(1601, 1);
        }
    }

    public String getDescription() {
        if (this.wmqQmanager.getQueueManagerName() != null) {
            return "Creating SPXListener \"" + this.wmqSpxListener.getListenerName() + "\" on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
        }
        return "Creating SPXListener Step";
    }

    protected String getSuccessMessage() {
        return "The SPXListener \"" + this.wmqSpxListener.getListenerName() + "\" is created on QueueManager \"" + this.wmqQmanager.getQueueManagerName() + "\"";
    }
}

