/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.Set;

class JWSAlgorithmMapJWSKeySelector<C extends SecurityContext>
implements JWSKeySelector<C> {
    private Map<JWSAlgorithm, JWSKeySelector<C>> jwsKeySelectors;

    JWSAlgorithmMapJWSKeySelector(Map<JWSAlgorithm, JWSKeySelector<C>> jwsKeySelectors) {
        this.jwsKeySelectors = jwsKeySelectors;
    }

    public List<? extends Key> selectJWSKeys(JWSHeader header, C context) throws KeySourceException {
        JWSKeySelector<C> keySelector = this.jwsKeySelectors.get(header.getAlgorithm());
        if (keySelector == null) {
            throw new IllegalArgumentException("Unsupported algorithm of " + header.getAlgorithm());
        }
        return keySelector.selectJWSKeys(header, context);
    }

    public Set<JWSAlgorithm> getExpectedJWSAlgorithms() {
        return this.jwsKeySelectors.keySet();
    }
}

