/*
 * Decompiled with CFR 0.152.
 */
package akka.http.impl.engine.client;

import akka.Done;
import akka.Done$;
import akka.actor.ActorRefFactory;
import akka.annotation.InternalStableApi;
import akka.event.LoggingAdapter;
import akka.http.impl.engine.client.PoolFlow;
import akka.http.impl.engine.client.PoolGateway;
import akka.http.impl.engine.client.PoolInterface$;
import akka.http.impl.engine.client.PoolInterface$ShutdownReason$IdleTimeout$;
import akka.http.impl.engine.client.PoolInterface$ShutdownReason$ShutdownRequested$;
import akka.http.impl.settings.HostConnectionPoolSetup;
import akka.http.impl.util.StreamUtils$;
import akka.http.impl.util.StreamUtils$CaptureTerminationOp$;
import akka.http.impl.util.package$;
import akka.http.impl.util.package$RichHttpRequest$;
import akka.http.javadsl.ConnectionContext;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.HttpResponse$;
import akka.http.scaladsl.model.OptHttpResponse$;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Host;
import akka.http.scaladsl.model.headers.Host$;
import akka.stream.Attributes;
import akka.stream.BufferOverflowException;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Materializer;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.AsyncCallback;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.GraphStageWithMaterializedValue;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import akka.stream.stage.TimerGraphStageLogic;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r}g\u0001C0a!\u0003\r\nA\u001a6\t\u000bE\u0004a\u0011A:\t\u000f\u0005]\u0001A\"\u0001\u0002\u001a!911\u0012\u0001\u0007\u0002\ruw\u0001CA\u0015A\"\u0005a-a\u000b\u0007\u000f}\u0003\u0007\u0012\u00014\u0002.!9\u0011qF\u0003\u0005\u0002\u0005EbACA\u001a\u000bA\u0005\u0019\u0013\u00054\u00026\u001dA\u0011qY\u0003\t\u0002\u0019\fyD\u0002\u0005\u00024\u0015A\tAZA\u001e\u0011\u001d\ty#\u0003C\u0001\u0003{9q!a\u0011\n\u0011\u0003\u000b)EB\u0004\u0002J%A\t)a\u0013\t\u000f\u0005=B\u0002\"\u0001\u0002\\!I\u0011Q\f\u0007\u0002\u0002\u0013\u0005\u0013q\f\u0005\n\u0003cb\u0011\u0011!C\u0001\u0003gB\u0011\"a\u001f\r\u0003\u0003%\t!! \t\u0013\u0005%E\"!A\u0005B\u0005-\u0005\"CAM\u0019\u0005\u0005I\u0011AAN\u0011%\t)\u000bDA\u0001\n\u0003\n9\u000bC\u0005\u0002*2\t\t\u0011\"\u0011\u0002,\"I\u0011Q\u0016\u0007\u0002\u0002\u0013%\u0011qV\u0004\b\u0003oK\u0001\u0012QA]\r\u001d\tI$\u0003EA\u0003wCq!a\f\u0018\t\u0003\ti\fC\u0005\u0002^]\t\t\u0011\"\u0011\u0002`!I\u0011\u0011O\f\u0002\u0002\u0013\u0005\u00111\u000f\u0005\n\u0003w:\u0012\u0011!C\u0001\u0003\u007fC\u0011\"!#\u0018\u0003\u0003%\t%a#\t\u0013\u0005eu#!A\u0005\u0002\u0005\r\u0007\"CAS/\u0005\u0005I\u0011IAT\u0011%\tIkFA\u0001\n\u0003\nY\u000bC\u0005\u0002.^\t\t\u0011\"\u0003\u00020\"9\u0011\u0011Z\u0003\u0005\u0002\u0005-\u0007\"CA\\\u000b\t\u0007I\u0011BA0\u0011!\tY0\u0002Q\u0001\n\u0005\u0005dABA\u007f\u000b\u0001\ty\u0010\u0003\u0006\u0002d\u0012\u0012\t\u0011)A\u0005\u0003KD!B!\u0011%\u0005\u0003\u0005\u000b\u0011\u0002B\"\u0011\u001d\ty\u0003\nC\u0001\u0005\u001fB\u0011Ba\u0016%\u0005\u0004%IA!\u0017\t\u0011\t\u0005D\u0005)A\u0005\u00057B\u0011Ba\u0019%\u0005\u0004%IA!\u001a\t\u0011\t5D\u0005)A\u0005\u0005OBqAa\u001c%\t\u0003\u0012\t\bC\u0004\u0003t\u0011\"\tE!\u001e\t\u000f\tMD\u0005\"\u0011\u0003\u000e\u001a1!QS\u0003\u0005\u0005/C!\"a90\u0005\u0003\u0005\u000b\u0011BAs\u0011)\u0011yg\fB\u0001B\u0003%!Q\u0002\u0005\u000b\u0005/z#\u0011!Q\u0001\n\tm\u0003B\u0003B2_\t\u0005\t\u0015!\u0003\u0003h!Q!\u0011I\u0018\u0003\u0002\u0003\u0006IAa\u0011\t\u0015\t-vF!A!\u0002\u0017\u0011i\u000bC\u0004\u00020=\"\tAa-\t\u0011\t\u0015w\u0006)A\u0005\u0005\u000fD\u0011B!40\u0005\u0004%\tAa4\t\u0011\tuw\u0006)A\u0005\u0005#D\u0011Ba80\u0005\u0004%\tA!9\t\u0011\t=x\u0006)A\u0005\u0005GD\u0011B!=0\u0005\u0004%\tAa=\t\u0011\t]x\u0006)A\u0005\u0005kDqA!?0\t\u0003\u0011Y\u0010C\u0005\u0003~>\u0002\r\u0011\"\u0001\u0003\u0000\"I1qA\u0018A\u0002\u0013\u00051\u0011\u0002\u0005\t\u0007\u001by\u0003\u0015)\u0003\u0004\u0002!I1qB\u0018A\u0002\u0013\u0005\u00111\u000f\u0005\n\u0007#y\u0003\u0019!C\u0001\u0007'A\u0001ba\u00060A\u0003&\u0011Q\u000f\u0005\b\u00073yC\u0011IB\u000e\u0011\u001d\u0019ib\fC)\u0007?Aqa!\n0\t\u0003\u001aY\u0002C\u0004\u0004(=\"\tea\u0007\t\u0013\r%rF1A\u0005\u0002\r-\u0002\u0002CB\u001e_\u0001\u0006Ia!\f\t\u0013\rurF1A\u0005\u0002\r}\u0002\u0002CB#_\u0001\u0006Ia!\u0011\t\u0013\r\u001dsF1A\u0005\u0002\r%\u0003\u0002CB'_\u0001\u0006Iaa\u0013\t\u000f\r=s\u0006\"\u0001\u0004\u001c!91\u0011K\u0018\u0005\u0002\rM\u0003bBB-_\u0011\u000511\u0004\u0005\b\u00077zC\u0011AB\u000e\u0011\u001d\u0019if\fC\u0001\u0005wDqaa\u00180\t\u0003\u001a\t\u0007C\u0004\u0004z=\"\tea\u0007\t\rE|C\u0011IB>\u0011\u001d\t9b\fC!\u0007\u0003Cqaa#0\t\u0003\u001ai\tC\u0004\u0004\u0010>\"\ta!%\t\u000f\r\rv\u0006\"\u0001\u0004&\"911V\u0018\u0005\u0002\r5\u0006bBBb_\u0011\u00051Q\u0019\u0005\u000b\u0007\u001f,!\u0019!C\u0001M\u000eE\u0007\u0002CBm\u000b\u0001\u0006Iaa5\u0003\u001bA{w\u000e\\%oi\u0016\u0014h-Y2f\u0015\t\t'-\u0001\u0004dY&,g\u000e\u001e\u0006\u0003G\u0012\fa!\u001a8hS:,'BA3g\u0003\u0011IW\u000e\u001d7\u000b\u0005\u001dD\u0017\u0001\u00025uiBT\u0011![\u0001\u0005C.\\\u0017m\u0005\u0002\u0001WB\u0011An\\\u0007\u0002[*\ta.A\u0003tG\u0006d\u0017-\u0003\u0002q[\n1\u0011I\\=SK\u001a\fqA]3rk\u0016\u001cHo\u0001\u0001\u0015\tQ<\u0018\u0011\u0001\t\u0003YVL!A^7\u0003\tUs\u0017\u000e\u001e\u0005\u0006c\u0006\u0001\r\u0001\u001f\t\u0003szl\u0011A\u001f\u0006\u0003wr\fQ!\\8eK2T!! 4\u0002\u0011M\u001c\u0017\r\\1eg2L!a >\u0003\u0017!#H\u000f\u001d*fcV,7\u000f\u001e\u0005\b\u0003\u0007\t\u0001\u0019AA\u0003\u0003=\u0011Xm\u001d9p]N,\u0007K]8nSN,\u0007CBA\u0004\u0003\u001b\t\t\"\u0004\u0002\u0002\n)\u0019\u00111B7\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u0010\u0005%!a\u0002)s_6L7/\u001a\t\u0004s\u0006M\u0011bAA\u000bu\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0002\u001cQ!\u0011QDBn!\u0019\t9!a\b\u0002$%!\u0011\u0011EA\u0005\u0005\u00191U\u000f^;sKB\u0019\u0011QE\u0004\u000f\u0007\u0005\u001dB!D\u0001a\u00035\u0001vn\u001c7J]R,'OZ1dKB\u0019\u0011qE\u0003\u0014\u0005\u0015Y\u0017A\u0002\u001fj]&$h\b\u0006\u0002\u0002,\tq1\u000b[;uI><hNU3bg>t7CA\u0004lS\r9q\u0003\u0004\u0002\f\u0013\u0012dW\rV5nK>,Ho\u0005\u0002\nWR\u0011\u0011q\b\t\u0004\u0003\u0003JQ\"A\u0003\u0002#MCW\u000f\u001e3po:\u0014V-];fgR,G\rE\u0002\u0002H1i\u0011!\u0003\u0002\u0012'\",H\u000fZ8x]J+\u0017/^3ti\u0016$7\u0003\u0003\u0007l\u0003\u001b\ny%!\u0016\u0011\u0007\u0005\u0005s\u0001E\u0002m\u0003#J1!a\u0015n\u0005\u001d\u0001&o\u001c3vGR\u00042\u0001\\A,\u0013\r\tI&\u001c\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003\u000b\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA1!\u0011\t\u0019'!\u001c\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nA\u0001\\1oO*\u0011\u00111N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002p\u0005\u0015$AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002vA\u0019A.a\u001e\n\u0007\u0005eTNA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0000\u0005\u0015\u0005c\u00017\u0002\u0002&\u0019\u00111Q7\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\bB\t\t\u00111\u0001\u0002v\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!$\u0011\r\u0005=\u0015QSA@\u001b\t\t\tJC\u0002\u0002\u00146\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9*!%\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003;\u000b\u0019\u000bE\u0002m\u0003?K1!!)n\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\"\u0013\u0003\u0003\u0005\r!a \u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u001e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003c\u0003B!a\u0019\u00024&!\u0011QWA3\u0005\u0019y%M[3di\u0006Y\u0011\n\u001a7f)&lWm\\;u!\r\t9eF\n\t/-\fi%a\u0014\u0002VQ\u0011\u0011\u0011\u0018\u000b\u0005\u0003\u007f\n\t\rC\u0005\u0002\bn\t\t\u00111\u0001\u0002vQ!\u0011QTAc\u0011%\t9)HA\u0001\u0002\u0004\ty(\u0001\bTQV$Hm\\<o%\u0016\f7o\u001c8\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u00055\u0017\u0011]Av)\u0011\ty-!5\u0011\u0007\u0005\u001d\u0002\u0001C\u0004\u0002T\u0006\u0002\u001d!!6\u0002\u0005\u0019l\u0007\u0003BAl\u0003;l!!!7\u000b\u0007\u0005m\u0007.\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003?\fIN\u0001\u0007NCR,'/[1mSj,'\u000fC\u0004\u0002d\u0006\u0002\r!!:\u0002\u000f\u001d\fG/Z<bsB!\u0011qEAt\u0013\r\tI\u000f\u0019\u0002\f!>|GnR1uK^\f\u0017\u0010C\u0004\u0002n\u0006\u0002\r!a<\u0002\rA\f'/\u001a8u!\u0011\t\t0a>\u000e\u0005\u0005M(bAA{Q\u0006)\u0011m\u0019;pe&!\u0011\u0011`Az\u0005=\t5\r^8s%\u00164g)Y2u_JL\u0018\u0001D%eY\u0016$\u0016.\\3pkR\u0004#A\u0005)p_2Le\u000e^3sM\u0006\u001cWm\u0015;bO\u0016\u001c2\u0001\nB\u0001!!\u0011\u0019A!\u0003\u0003\u000e\u0005=WB\u0001B\u0003\u0015\u0011\u00119!!7\u0002\u000bM$\u0018mZ3\n\t\t-!Q\u0001\u0002 \u000fJ\f\u0007\u000f[*uC\u001e,w+\u001b;i\u001b\u0006$XM]5bY&TX\r\u001a,bYV,\u0007\u0003CAl\u0005\u001f\u0011\u0019Ba\u000f\n\t\tE\u0011\u0011\u001c\u0002\n\r2|wo\u00155ba\u0016\u0004BA!\u0006\u000369!!q\u0003B\u0019\u001d\u0011\u0011IBa\f\u000f\t\tm!Q\u0006\b\u0005\u0005;\u0011YC\u0004\u0003\u0003 \t%b\u0002\u0002B\u0011\u0005Oi!Aa\t\u000b\u0007\t\u0015\"/\u0001\u0004=e>|GOP\u0005\u0002S&\u0011q\r[\u0005\u0003K\u001aL!a\u00193\n\u0005\u0005\u0014\u0017b\u0001B\u001aA\u0006A\u0001k\\8m\r2|w/\u0003\u0003\u00038\te\"a\u0004*fgB|gn]3D_:$X\r\u001f;\u000b\u0007\tM\u0002\r\u0005\u0003\u0003\u0016\tu\u0012\u0002\u0002B \u0005s\u0011aBU3rk\u0016\u001cHoQ8oi\u0016DH/A\u0002m_\u001e\u0004BA!\u0012\u0003L5\u0011!q\t\u0006\u0004\u0005\u0013B\u0017!B3wK:$\u0018\u0002\u0002B'\u0005\u000f\u0012a\u0002T8hO&tw-\u00113baR,'\u000f\u0006\u0004\u0003R\tM#Q\u000b\t\u0004\u0003\u0003\"\u0003bBArO\u0001\u0007\u0011Q\u001d\u0005\b\u0005\u0003:\u0003\u0019\u0001B\"\u0003)\u0011X-];fgR|U\u000f^\u000b\u0003\u00057\u0002b!a6\u0003^\tm\u0012\u0002\u0002B0\u00033\u0014aaT;uY\u0016$\u0018a\u0003:fcV,7\u000f^(vi\u0002\n!B]3ta>t7/Z%o+\t\u00119\u0007\u0005\u0004\u0002X\n%$1C\u0005\u0005\u0005W\nINA\u0003J]2,G/A\u0006sKN\u0004xN\\:f\u0013:\u0004\u0013!B:iCB,WC\u0001B\u0007\u0003}\u0019'/Z1uK2{w-[2B]\u0012l\u0015\r^3sS\u0006d\u0017N_3e-\u0006dW/\u001a\u000b\u0005\u0005o\u0012\u0019\tE\u0004m\u0005s\u0012i(a4\n\u0007\tmTN\u0001\u0004UkBdWM\r\t\u0005\u0005\u0007\u0011y(\u0003\u0003\u0003\u0002\n\u0015!aD$sCBD7\u000b^1hK2{w-[2\t\u000f\t\u0015U\u00061\u0001\u0003\b\u0006\u0019\u0012N\u001c5fe&$X\rZ!uiJL'-\u001e;fgB!\u0011q\u001bBE\u0013\u0011\u0011Y)!7\u0003\u0015\u0005#HO]5ckR,7\u000f\u0006\u0004\u0003x\t=%\u0011\u0013\u0005\b\u0005\u000bs\u0003\u0019\u0001BD\u0011\u001d\u0011\u0019J\fa\u0001\u0003+\fQbX7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014(!\u0002'pO&\u001c7#C\u0018\u0003\u001a\u0006='q\u0014BS!\u0011\u0011\u0019Aa'\n\t\tu%Q\u0001\u0002\u0015)&lWM]$sCBD7\u000b^1hK2{w-[2\u0011\t\t\r!\u0011U\u0005\u0005\u0005G\u0013)AA\u0005J]\"\u000bg\u000e\u001a7feB!!1\u0001BT\u0013\u0011\u0011IK!\u0002\u0003\u0015=+H\u000fS1oI2,'/\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB!\u0011q\u0001BX\u0013\u0011\u0011\t,!\u0003\u0003!\u0015CXmY;uS>t7i\u001c8uKb$H\u0003\u0004B[\u0005w\u0013iLa0\u0003B\n\rG\u0003\u0002B\\\u0005s\u00032!!\u00110\u0011\u001d\u0011YK\u000ea\u0002\u0005[Cq!a97\u0001\u0004\t)\u000fC\u0004\u0003pY\u0002\rA!\u0004\t\u000f\t]c\u00071\u0001\u0003\\!9!1\r\u001cA\u0002\t\u001d\u0004b\u0002B!m\u0001\u0007!1I\u0001\u0016!>|Gn\u0014<fe\u001adwn^#yG\u0016\u0004H/[8o!\u0011\t9N!3\n\t\t-\u0017\u0011\u001c\u0002\u0018\u0005V4g-\u001a:Pm\u0016\u0014h\r\\8x\u000bb\u001cW\r\u001d;j_:\fA\u0001[2qgV\u0011!\u0011\u001b\t\u0005\u0005'\u0014I.\u0004\u0002\u0003V*\u0019!q\u001b3\u0002\u0011M,G\u000f^5oONLAAa7\u0003V\n9\u0002j\\:u\u0007>tg.Z2uS>t\u0007k\\8m'\u0016$X\u000f]\u0001\u0006Q\u000e\u00048\u000fI\u0001\fS\u0012dW\rV5nK>,H/\u0006\u0002\u0003dB!!Q\u001dBv\u001b\t\u00119O\u0003\u0003\u0003j\u0006%\u0011\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\t5(q\u001d\u0002\t\tV\u0014\u0018\r^5p]\u0006a\u0011\u000e\u001a7f)&lWm\\;uA\u0005y1\u000f[;uI><h\u000e\u0015:p[&\u001cX-\u0006\u0002\u0003vB1\u0011qAA\u0007\u0003\u001b\n\u0001c\u001d5vi\u0012|wO\u001c)s_6L7/\u001a\u0011\u0002\u0019MDW\u000f\u001e;j]\u001e$un\u001e8\u0016\u0005\u0005u\u0015AE:ikR$\u0018N\\4E_^t'+Z1t_:,\"a!\u0001\u0011\u000b1\u001c\u0019!!\u0014\n\u0007\r\u0015QN\u0001\u0004PaRLwN\\\u0001\u0017g\",H\u000f^5oO\u0012{wO\u001c*fCN|gn\u0018\u0013fcR\u0019Aoa\u0003\t\u0013\u0005\u001d\u0005)!AA\u0002\r\u0005\u0011aE:ikR$\u0018N\\4E_^t'+Z1t_:\u0004\u0013A\u0005:f[\u0006Lg.\u001b8h%\u0016\fX/Z:uK\u0012\faC]3nC&t\u0017N\\4SKF,Xm\u001d;fI~#S-\u001d\u000b\u0004i\u000eU\u0001\"CAD\u0007\u0006\u0005\t\u0019AA;\u0003M\u0011X-\\1j]&twMU3rk\u0016\u001cH/\u001a3!\u0003!\u0001(/Z*uCJ$H#\u0001;\u0002\u000f=tG+[7feR\u0019Ao!\t\t\u000f\r\rb\t1\u0001\u0002\u0000\u0005AA/[7fe.+\u00170\u0001\u0004p]B+8\u000f[\u0001\u0007_:\u0004V\u000f\u001c7\u00023I,7\u000f]8og\u0016\u001cu.\u001c9mKR,GmQ1mY\n\f7m[\u000b\u0003\u0007[\u0001bAa\u0001\u00040\rM\u0012\u0002BB\u0019\u0005\u000b\u0011Q\"Q:z]\u000e\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003BB\u001b\u0007oi\u0011\u0001[\u0005\u0004\u0007sA'\u0001\u0002#p]\u0016\f!D]3ta>t7/Z\"p[BdW\r^3e\u0007\u0006dGNY1dW\u0002\nqB]3rk\u0016\u001cHoQ1mY\n\f7m[\u000b\u0003\u0007\u0003\u0002bAa\u0001\u00040\r\r\u0003C\u00027\u0003za\f)!\u0001\tsKF,Xm\u001d;DC2d'-Y2lA\u0005\u00012\u000f[;uI><hnQ1mY\n\f7m[\u000b\u0003\u0007\u0017\u0002RAa\u0001\u00040Q\f\u0011c\u001d5vi\u0012|wO\\\"bY2\u0014\u0017mY6!\u0003Q\tg\r^3s%\u0016\fX/Z:u\r&t\u0017n\u001d5fI\u0006y!/Z9vKN$8\u000b[;uI><h\u000eF\u0002u\u0007+Bqaa\u0016Q\u0001\u0004\ti%\u0001\u0004sK\u0006\u001cxN\\\u0001\u001fg\",H\u000fZ8x]&3'+Z9vKN$X\rZ!oIB{7o]5cY\u0016\faB]3tKRLE\r\\3US6,'/\u0001\ttQ>,H\u000eZ*u_B|e.\u00133mK\u0006\trN\\+qgR\u0014X-Y7GC&dWO]3\u0015\u0007Q\u001c\u0019\u0007C\u0004\u0004fQ\u0003\raa\u001a\u0002\u0005\u0015D\b\u0003BB5\u0007grAaa\u001b\u0004p9!!\u0011EB7\u0013\u0005q\u0017bAB9[\u00069\u0001/Y2lC\u001e,\u0017\u0002BB;\u0007o\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\rET.\u0001\u0005q_N$8\u000b^8q)\u0015!8QPB@\u0011\u0015\th\u000b1\u0001y\u0011\u001d\t\u0019A\u0016a\u0001\u0003\u000b!\"aa!\u0015\t\r\u00155q\u0011\t\u0007\u0003\u000f\ty\"!\u0014\t\u000f\r%u\u000bq\u0001\u0003.\u0006\u0011QmY\u0001\ro\",gn\u00155vi\u0012|wO\\\u000b\u0003\u0007\u000b\u000baa\u001c8J]&$Hc\u0001;\u0004\u0014\"9\u00111]-A\u0002\u0005\u0015\bfA-\u0004\u0018B!1\u0011TBP\u001b\t\u0019YJC\u0002\u0004\u001e\"\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0019\tka'\u0003#%sG/\u001a:oC2\u001cF/\u00192mK\u0006\u0003\u0018.\u0001\u0006p]\u0012K7\u000f]1uG\"$2\u0001_BT\u0011\u0015\t(\f1\u0001yQ\rQ6qS\u0001\u000b_:\u0014Vm\u001d9p]N,GCBA@\u0007_\u001b\t\fC\u0003r7\u0002\u0007\u0001\u0010C\u0004\u00044n\u0003\ra!.\u0002\u0011I,7\u000f]8og\u0016\u0004baa.\u0004>\u0006EQBAB]\u0015\r\u0019Y,\\\u0001\u0005kRLG.\u0003\u0003\u0004@\u000ee&a\u0001+ss\"\u001a1la&\u0002%=t'+Z:q_:\u001cXmQ8na2,G/\u001a\u000b\u0004i\u000e\u001d\u0007bBBe9\u0002\u0007\u0011qP\u0001\u0004C:L\bf\u0001/\u0004\u0018\"\u001aqfa&\u0002!\u001d\u000bG/Z<bs2{wmU8ve\u000e,WCABj!\u0019\u0011)e!6\u0002f&!1q\u001bB$\u0005%aunZ*pkJ\u001cW-A\tHCR,w/Y=M_\u001e\u001cv.\u001e:dK\u0002Bqa!#\u0003\u0001\b\u0011i+\u0006\u0002\u0002\u001e\u0001")
public interface PoolInterface {
    public static PoolInterface apply(PoolGateway poolGateway, ActorRefFactory actorRefFactory, Materializer materializer) {
        return PoolInterface$.MODULE$.apply(poolGateway, actorRefFactory, materializer);
    }

    public void request(HttpRequest var1, Promise<HttpResponse> var2);

    public Future<ShutdownReason> shutdown(ExecutionContext var1);

    public Future<ShutdownReason> whenShutdown();

    @InternalStableApi
    public static class Logic
    extends TimerGraphStageLogic
    implements PoolInterface,
    InHandler,
    OutHandler {
        private final PoolGateway gateway;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;
        private final LoggingAdapter log;
        private final ExecutionContext executionContext;
        private final BufferOverflowException PoolOverflowException;
        private final HostConnectionPoolSetup hcps;
        private final Duration idleTimeout;
        private final Promise<ShutdownReason> shutdownPromise;
        private Option<ShutdownReason> shuttingDownReason;
        private int remainingRequested;
        private final AsyncCallback<Done> responseCompletedCallback;
        private final AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback;
        private final AsyncCallback<BoxedUnit> shutdownCallback;

        public void onDownstreamFinish() throws Exception {
            OutHandler.onDownstreamFinish$((OutHandler)this);
        }

        public void onUpstreamFinish() throws Exception {
            InHandler.onUpstreamFinish$((InHandler)this);
        }

        public HostConnectionPoolSetup hcps() {
            return this.hcps;
        }

        public Duration idleTimeout() {
            return this.idleTimeout;
        }

        public Promise<ShutdownReason> shutdownPromise() {
            return this.shutdownPromise;
        }

        public boolean shuttingDown() {
            return this.shuttingDownReason().isDefined();
        }

        public Option<ShutdownReason> shuttingDownReason() {
            return this.shuttingDownReason;
        }

        public void shuttingDownReason_$eq(Option<ShutdownReason> x$1) {
            this.shuttingDownReason = x$1;
        }

        public int remainingRequested() {
            return this.remainingRequested;
        }

        public void remainingRequested_$eq(int x$1) {
            this.remainingRequested = x$1;
        }

        public void preStart() {
            this.onInit(this.gateway);
            this.pull(this.responseIn);
            this.resetIdleTimer();
        }

        public void onTimer(Object timerKey) {
            this.log.debug(new StringBuilder(88).append("Pool shutting down because akka.http.host-connection-pool.idle-timeout triggered after ").append(this.idleTimeout()).append(".").toString());
            this.requestShutdown(PoolInterface$ShutdownReason$IdleTimeout$.MODULE$);
        }

        /*
         * Unable to fully structure code
         */
        public void onPush() {
            var5_1 = (PoolFlow.ResponseContext)this.grab(this.responseIn);
            if (var5_1 == null) {
                throw new MatchError((Object)var5_1);
            }
            rc = var5_1.rc();
            response0 = var5_1.response();
            var3_4 = new Tuple2((Object)rc, response0);
            var4_5 = var3_4;
            rc = (PoolFlow.RequestContext)var4_5._1();
            response0 = (Try)var4_5._2();
            ctx = this.onResponse(rc.request(), (Try<HttpResponse>)response0);
            var12_9 = false;
            var13_10 = null;
            var14_11 = response0;
            if (!(var14_11 instanceof Success)) ** GOTO lbl-1000
            var12_9 = true;
            var13_10 = (Success)var14_11;
            r = (HttpResponse)var13_10.value();
            var16_13 = HttpResponse$.MODULE$.unapply(r);
            if (!OptHttpResponse$.MODULE$.isEmpty$extension(var16_13) && !(entity = var16_13._3()).isStrict()) {
                var19_15 = StreamUtils$.MODULE$.transformEntityStream(entity, StreamUtils$CaptureTerminationOp$.MODULE$);
                if (var19_15 == null) {
                    throw new MatchError(var19_15);
                }
                newEntity = (ResponseEntity)var19_15._1();
                termination = (Future)var19_15._2();
                var2_18 = new Tuple2((Object)newEntity, (Object)termination);
                var18_19 = var2_18;
                newEntity = (ResponseEntity)var18_19._1();
                termination = (Future)var18_19._2();
                termination.onComplete((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$onPush$1$adapted(akka.http.impl.engine.client.PoolInterface$Logic scala.util.Try ), (Lscala/util/Try;)Ljava/lang/Object;)((Logic)this), this.executionContext);
                var1_22 = new Success((Object)r.withEntity(newEntity));
            } else if (var12_9) {
                response = (HttpResponse)var13_10.value();
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                var1_22 = new Success((Object)response);
            } else if (var14_11 instanceof Failure) {
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                var1_22 = response0;
            } else {
                throw new MatchError((Object)var14_11);
            }
            response1 = var1_22;
            rc.responsePromise().complete(response1);
            this.onResponseComplete(ctx);
            this.pull(this.responseIn);
            this.afterRequestFinished();
        }

        public void onPull() {
        }

        public AsyncCallback<Done> responseCompletedCallback() {
            return this.responseCompletedCallback;
        }

        public AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback() {
            return this.requestCallback;
        }

        public AsyncCallback<BoxedUnit> shutdownCallback() {
            return this.shutdownCallback;
        }

        public void afterRequestFinished() {
            this.shutdownIfRequestedAndPossible();
            this.resetIdleTimer();
        }

        public void requestShutdown(ShutdownReason reason) {
            this.shuttingDownReason_$eq((Option<ShutdownReason>)new Some((Object)reason));
            this.shutdownIfRequestedAndPossible();
        }

        public void shutdownIfRequestedAndPossible() {
            block2: {
                if (!this.shuttingDown()) break block2;
                if (this.remainingRequested() == 0) {
                    this.log.debug("Pool is now shutting down as requested.");
                    this.shutdownPromise().trySuccess(this.shuttingDownReason().get());
                    this.completeStage();
                } else {
                    this.log.debug(new StringBuilder(64).append("Pool is shutting down after waiting for [").append(this.remainingRequested()).append("] outstanding requests.").toString());
                }
            }
        }

        public void resetIdleTimer() {
            block0: {
                this.cancelTimer(PoolInterface$.MODULE$.akka$http$impl$engine$client$PoolInterface$$IdleTimeout());
                if (!this.shouldStopOnIdle()) break block0;
                this.scheduleOnce(PoolInterface$.MODULE$.akka$http$impl$engine$client$PoolInterface$$IdleTimeout(), (FiniteDuration)this.idleTimeout());
            }
        }

        public boolean shouldStopOnIdle() {
            return !this.shuttingDown() && this.remainingRequested() == 0 && this.idleTimeout().isFinite() && this.hcps().setup().settings().minConnections() == 0;
        }

        public void onUpstreamFailure(Throwable ex) {
            this.shutdownPromise().tryFailure(ex);
        }

        public void postStop() {
            this.shutdownPromise().tryFailure((Throwable)new IllegalStateException("Pool shutdown unexpectedly"));
        }

        @Override
        public void request(HttpRequest request, Promise<HttpResponse> responsePromise) {
            this.requestCallback().invokeWithFeedback((Object)new Tuple2((Object)request, responsePromise)).failed().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                $this.log.debug("Request was sent to pool which was already closed, retrying through the gateway to create new pool instance");
                return responsePromise.tryCompleteWith($this.gateway.apply(request));
            }, this.executionContext);
        }

        @Override
        public Future<ShutdownReason> shutdown(ExecutionContext ec) {
            this.shutdownCallback().invoke((Object)BoxedUnit.UNIT);
            return this.whenShutdown();
        }

        @Override
        public Future<ShutdownReason> whenShutdown() {
            return this.shutdownPromise().future();
        }

        @InternalStableApi
        public void onInit(PoolGateway gateway) {
        }

        @InternalStableApi
        public HttpRequest onDispatch(HttpRequest request) {
            return request;
        }

        @InternalStableApi
        public Object onResponse(HttpRequest request, Try<HttpResponse> response) {
            return None$.MODULE$;
        }

        @InternalStableApi
        public void onResponseComplete(Object any) {
        }

        public static final /* synthetic */ void $anonfun$onPush$1(Logic $this, Try x$3) {
            $this.responseCompletedCallback().invoke((Object)Done$.MODULE$);
        }

        public static final /* synthetic */ void $anonfun$responseCompletedCallback$1(Logic $this, Done x$4) {
            $this.remainingRequested_$eq($this.remainingRequested() - 1);
            $this.afterRequestFinished();
        }

        public static final /* synthetic */ void $anonfun$requestCallback$1(Logic $this, Tuple2 x0$1) {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                HttpRequest request = (HttpRequest)tuple2._1();
                Promise responsePromise = (Promise)tuple2._2();
                if ($this.isAvailable($this.requestOut)) {
                    $this.log.debug(new StringBuilder(30).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] to pool").toString());
                    String scheme = Uri$.MODULE$.httpScheme(((ConnectionContext)((Object)$this.hcps().setup().connectionContext())).isSecure());
                    Host hostHeader = Host$.MODULE$.apply($this.hcps().host(), Uri$.MODULE$.normalizePort($this.hcps().port(), scheme));
                    HttpRequest effectiveRequest = $this.onDispatch((HttpRequest)request.withUri(request.uri().toHttpRequestTargetOriginForm()).withDefaultHeaders((Seq<HttpHeader>)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[]{hostHeader})));
                    int retries = request.method().isIdempotent() ? $this.hcps().setup().settings().maxRetries() : 0;
                    $this.remainingRequested_$eq($this.remainingRequested() + 1);
                    $this.resetIdleTimer();
                    $this.push($this.requestOut, new PoolFlow.RequestContext(effectiveRequest, (Promise<HttpResponse>)responsePromise, retries));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.log.debug(new StringBuilder(52).append("Could not dispatch request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] because buffer is full").toString());
                    responsePromise.tryFailure((Throwable)$this.PoolOverflowException);
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }

        public Logic(PoolGateway gateway, FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape, Outlet<PoolFlow.RequestContext> requestOut, Inlet<PoolFlow.ResponseContext> responseIn, LoggingAdapter log, ExecutionContext executionContext) {
            this.gateway = gateway;
            this.requestOut = requestOut;
            this.responseIn = responseIn;
            this.log = log;
            this.executionContext = executionContext;
            super(shape);
            InHandler.$init$((InHandler)this);
            OutHandler.$init$((OutHandler)this);
            this.PoolOverflowException = new BufferOverflowException(new StringBuilder(369).append("Exceeded configured max-open-requests value of [").append(gateway.hcps().setup().settings().maxOpenRequests()).append("]. This means that the request queue of this pool (").append(gateway.hcps()).append(") ").append("has completely filled up because the pool currently does not process requests fast enough to handle the incoming request load. ").append("Please retry the request later. See http://doc.akka.io/docs/akka-http/current/scala/http/client-side/pool-overflow.html for ").append("more information.").toString());
            this.hcps = gateway.hcps();
            this.idleTimeout = this.hcps().setup().settings().idleTimeout();
            this.shutdownPromise = Promise$.MODULE$.apply();
            this.shuttingDownReason = None$.MODULE$;
            this.remainingRequested = 0;
            this.setHandlers(responseIn, requestOut, this);
            this.responseCompletedCallback = this.getAsyncCallback((Function1 & Serializable & scala.Serializable)x$4 -> {
                Logic.$anonfun$responseCompletedCallback$1(this, x$4);
                return BoxedUnit.UNIT;
            });
            this.requestCallback = this.getAsyncCallback((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Logic.$anonfun$requestCallback$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            this.shutdownCallback = this.getAsyncCallback((Function1 & Serializable & scala.Serializable)x$5 -> {
                this.requestShutdown(PoolInterface$ShutdownReason$ShutdownRequested$.MODULE$);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ Object $anonfun$onPush$1$adapted(Logic $this, Try x$3) {
            Logic.$anonfun$onPush$1($this, x$3);
            return BoxedUnit.UNIT;
        }
    }

    public static class PoolInterfaceStage
    extends GraphStageWithMaterializedValue<FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext>, PoolInterface> {
        private final PoolGateway gateway;
        private final LoggingAdapter log;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;

        private Outlet<PoolFlow.RequestContext> requestOut() {
            return this.requestOut;
        }

        private Inlet<PoolFlow.ResponseContext> responseIn() {
            return this.responseIn;
        }

        public FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape() {
            return new FlowShape(this.responseIn(), this.requestOut());
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
            throw new IllegalStateException("Should not be called");
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes, Materializer _materializer) {
            Logic logic = new Logic(this.gateway, this.shape(), this.requestOut(), this.responseIn(), this.log, (ExecutionContext)_materializer.executionContext());
            return new Tuple2((Object)logic, (Object)logic);
        }

        public PoolInterfaceStage(PoolGateway gateway, LoggingAdapter log) {
            this.gateway = gateway;
            this.log = log;
            this.requestOut = Outlet$.MODULE$.apply("PoolInterface.requestOut");
            this.responseIn = Inlet$.MODULE$.apply("PoolInterface.responseIn");
        }
    }

    public static interface ShutdownReason {
    }
}

