/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.compress;

import akka.remote.artery.compress.CompressionTable$;
import akka.remote.artery.compress.DecompressionTable;
import akka.remote.artery.compress.DecompressionTable$;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tUa!\u0002\u0013&\u0005&j\u0003\u0002C#\u0001\u0005+\u0007I\u0011\u0001$\t\u0011)\u0003!\u0011#Q\u0001\n\u001dC\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005j\u0001\tE\t\u0015!\u0003T\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u00151\u0003\u0001\"\u0001r\u0011\u0015!\b\u0001\"\u0001v\u0011\u001dI\b!!A\u0005\u0002iD\u0011\"a\u0002\u0001#\u0003%\t!!\u0003\t\u0013\u0005\r\u0002!%A\u0005\u0002\u0005\u0015\u0002\"CA\u0017\u0001E\u0005I\u0011AA\u0018\u0011%\t9\u0004AA\u0001\n\u0003\nI\u0004C\u0005\u0002L\u0001\t\t\u0011\"\u0001\u0002N!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u000b\u0005\n\u0003/\u0002\u0011\u0011!C!\u00033B\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\t\u0013\u0005M\u0004!!A\u0005B\u0005U\u0004\"CA=\u0001\u0005\u0005I\u0011IA>\u0011%\ti\bAA\u0001\n\u0003\ny\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0011\u0002\u0004\u001eA\u0011qQ\u0013\t\u0002%\nIIB\u0004%K!\u0005\u0011&a#\t\r)DB\u0011AAL\u0011%\tI\n\u0007b\u0001\n\u000b\tY\n\u0003\u0005\u0002\"b\u0001\u000bQBAO\u0011%\t\u0019\u000b\u0007b\u0001\n\u000b\t)\u000b\u0003\u0005\u0002@b\u0001\u000bQBAT\u0011\u001d\t\t\r\u0007C\u0001\u0003\u0007D\u0001\"a4\u0019A\u0003%\u0011\u0011\u001b\u0005\b\u0003'DB\u0011AAk\u0011%\ty\u000eGA\u0001\n\u0003\u000b\t\u000fC\u0005\u0002tb\t\t\u0011\"!\u0002v\"I!\u0011\u0003\r\u0002\u0002\u0013%!1\u0003\u0002\u0011\u0007>l\u0007O]3tg&|g\u000eV1cY\u0016T!AJ\u0014\u0002\u0011\r|W\u000e\u001d:fgNT!\u0001K\u0015\u0002\r\u0005\u0014H/\u001a:z\u0015\tQ3&\u0001\u0004sK6|G/\u001a\u0006\u0002Y\u0005!\u0011m[6b+\tqSl\u0005\u0003\u0001_UB\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g\r\u0005\u00021m%\u0011q'\r\u0002\b!J|G-^2u!\tI$I\u0004\u0002;\u0001:\u00111hP\u0007\u0002y)\u0011QHP\u0001\u0007yI|w\u000e\u001e \u0004\u0001%\t!'\u0003\u0002Bc\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\t\u0015'A\u0005pe&<\u0017N\\+jIV\tq\t\u0005\u00021\u0011&\u0011\u0011*\r\u0002\u0005\u0019>tw-\u0001\u0006pe&<\u0017N\\+jI\u0002\nqA^3sg&|g.F\u0001N!\t\u0001d*\u0003\u0002Pc\t!!)\u001f;f\u0003!1XM]:j_:\u0004\u0013A\u00033jGRLwN\\1ssV\t1\u000b\u0005\u0003U1n3gBA+W!\tY\u0014'\u0003\u0002Xc\u00051\u0001K]3eK\u001aL!!\u0017.\u0003\u00075\u000b\u0007O\u0003\u0002XcA\u0011A,\u0018\u0007\u0001\t\u0015q\u0006A1\u0001`\u0005\u0005!\u0016C\u00011d!\t\u0001\u0014-\u0003\u0002cc\t9aj\u001c;iS:<\u0007C\u0001\u0019e\u0013\t)\u0017GA\u0002B]f\u0004\"\u0001M4\n\u0005!\f$aA%oi\u0006YA-[2uS>t\u0017M]=!\u0003\u0019a\u0014N\\5u}Q!AN\\8q!\ri\u0007aW\u0007\u0002K!)Qi\u0002a\u0001\u000f\")1j\u0002a\u0001\u001b\")\u0011k\u0002a\u0001'R\u0011aM\u001d\u0005\u0006g\"\u0001\raW\u0001\u0006m\u0006dW/Z\u0001\u0007S:4XM\u001d;\u0016\u0003Y\u00042!\\<\\\u0013\tAXE\u0001\nEK\u000e|W\u000e\u001d:fgNLwN\u001c+bE2,\u0017\u0001B2paf,\"a\u001f@\u0015\rq|\u0018\u0011AA\u0002!\ri\u0007! \t\u00039z$QA\u0018\u0006C\u0002}Cq!\u0012\u0006\u0011\u0002\u0003\u0007q\tC\u0004L\u0015A\u0005\t\u0019A'\t\u0011ES\u0001\u0013!a\u0001\u0003\u000b\u0001B\u0001\u0016-~M\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT\u0003BA\u0006\u0003C)\"!!\u0004+\u0007\u001d\u000bya\u000b\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!C;oG\",7m[3e\u0015\r\tY\"M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0010\u0003+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015q6B1\u0001`\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*B!a\n\u0002,U\u0011\u0011\u0011\u0006\u0016\u0004\u001b\u0006=A!\u00020\r\u0005\u0004y\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0005\u0003c\t)$\u0006\u0002\u00024)\u001a1+a\u0004\u0005\u000byk!\u0019A0\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0004\u0005\u0003\u0002>\u0005\u001dSBAA \u0015\u0011\t\t%a\u0011\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\nAA[1wC&!\u0011\u0011JA \u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\ta-\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\r\f\u0019\u0006\u0003\u0005\u0002VA\t\t\u00111\u0001g\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\f\t\u0006\u0003;\n\u0019gY\u0007\u0003\u0003?R1!!\u00192\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\nyF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA6\u0003c\u00022\u0001MA7\u0013\r\ty'\r\u0002\b\u0005>|G.Z1o\u0011!\t)FEA\u0001\u0002\u0004\u0019\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u000f\u0002x!A\u0011QK\n\u0002\u0002\u0003\u0007a-\u0001\u0005iCND7i\u001c3f)\u00051\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002l\u0005\u0015\u0005\u0002CA+-\u0005\u0005\t\u0019A2\u0002!\r{W\u000e\u001d:fgNLwN\u001c+bE2,\u0007CA7\u0019'\u0011Ar&!$\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#SA!a%\u0002D\u0005\u0011\u0011n\\\u0005\u0004\u0007\u0006EECAAE\u0003=qu\u000e^\"p[B\u0014Xm]:fI&#WCAAO\u001f\t\ty*H\u0001\u0000\u0004Aqu\u000e^\"p[B\u0014Xm]:fI&#\u0007%A\tD_6\u0004\u0018M]3CsJrGMV1mk\u0016,\"!a*\u0011\r\u0005%\u0016qVAZ\u001b\t\tYK\u0003\u0003\u0002.\u0006\r\u0013\u0001B;uS2LA!!-\u0002,\nQ1i\\7qCJ\fGo\u001c:\u0011\rA\n),!/g\u0013\r\t9,\r\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005u\u00121X\u0005\u0005\u0003{\u000byD\u0001\u0004PE*,7\r^\u0001\u0013\u0007>l\u0007/\u0019:f\u0005f\u0014d\u000e\u001a,bYV,\u0007%A\td_6\u0004\u0018M]3CsJrGMV1mk\u0016,B!!2\u0002NV\u0011\u0011q\u0019\t\u0007\u0003S\u000by+!3\u0011\rA\n),a3g!\ra\u0016Q\u001a\u0003\u0006=z\u0011\raX\u0001\u0007?\u0016l\u0007\u000f^=\u0011\u00075\u00041-A\u0003f[B$\u00180\u0006\u0003\u0002X\u0006uWCAAm!\u0011i\u0007!a7\u0011\u0007q\u000bi\u000eB\u0003_A\t\u0007q,A\u0003baBd\u00170\u0006\u0003\u0002d\u0006%H\u0003CAs\u0003W\fi/a<\u0011\t5\u0004\u0011q\u001d\t\u00049\u0006%H!\u00020\"\u0005\u0004y\u0006\"B#\"\u0001\u00049\u0005\"B&\"\u0001\u0004i\u0005BB)\"\u0001\u0004\t\t\u0010E\u0003U1\u0006\u001dh-A\u0004v]\u0006\u0004\b\u000f\\=\u0016\t\u0005](\u0011\u0002\u000b\u0005\u0003s\u0014Y\u0001E\u00031\u0003w\fy0C\u0002\u0002~F\u0012aa\u00149uS>t\u0007c\u0002\u0019\u0003\u0002\u001dk%QA\u0005\u0004\u0005\u0007\t$A\u0002+va2,7\u0007E\u0003U1\n\u001da\rE\u0002]\u0005\u0013!QA\u0018\u0012C\u0002}C\u0011B!\u0004#\u0003\u0003\u0005\rAa\u0004\u0002\u0007a$\u0003\u0007\u0005\u0003n\u0001\t\u001d\u0011\u0001D<sSR,'+\u001a9mC\u000e,GCAA]\u0001")
public final class CompressionTable<T>
implements Product,
Serializable {
    private final long originUid;
    private final byte version;
    private final Map<T, Object> dictionary;

    public static <T> Option<Tuple3<Object, Object, Map<T, Object>>> unapply(CompressionTable<T> compressionTable) {
        return CompressionTable$.MODULE$.unapply(compressionTable);
    }

    public static <T> CompressionTable<T> apply(long l, byte by, Map<T, Object> map) {
        return CompressionTable$.MODULE$.apply(l, by, map);
    }

    public static <T> CompressionTable<T> empty() {
        return CompressionTable$.MODULE$.empty();
    }

    public static <T> Comparator<Tuple2<T, Object>> compareBy2ndValue() {
        return CompressionTable$.MODULE$.compareBy2ndValue();
    }

    public static Comparator<Tuple2<Object, Object>> CompareBy2ndValue() {
        return CompressionTable$.MODULE$.CompareBy2ndValue();
    }

    public static int NotCompressedId() {
        return CompressionTable$.MODULE$.NotCompressedId();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public long originUid() {
        return this.originUid;
    }

    public byte version() {
        return this.version;
    }

    public Map<T, Object> dictionary() {
        return this.dictionary;
    }

    public int compress(T value) {
        int n;
        Option option = this.dictionary().get(value);
        if (option instanceof Some) {
            int id;
            Some some = (Some)option;
            n = id = BoxesRunTime.unboxToInt((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            n = -1;
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    public DecompressionTable<T> invert() {
        DecompressionTable decompressionTable;
        if (this.dictionary().isEmpty()) {
            DecompressionTable qual$1 = DecompressionTable$.MODULE$.empty();
            long x$1 = this.originUid();
            byte x$2 = this.version();
            Object x$3 = qual$1.copy$default$3();
            decompressionTable = qual$1.copy(x$1, x$2, x$3);
        } else {
            int i;
            Integer expectedGaplessSum = this.dictionary().size() * (this.dictionary().size() + 1) / 2;
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)this.dictionary().values().min((Ordering)Ordering.Int$.MODULE$)) == 0, (Function0 & Serializable)() -> new StringBuilder(78).append("Compression table should start allocating from 0, yet lowest allocated id was ").append(this.dictionary().values().min((Ordering)Ordering.Int$.MODULE$)).toString());
            Predef$.MODULE$.require(BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.dictionary().values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + this.dictionary().size())), (Object)expectedGaplessSum), (Function0 & Serializable)() -> new StringBuilder(149).append("Given compression map does not seem to be gap-less and starting from zero, which makes compressing it into an Array difficult, bailing out! Map was: ").append(this.dictionary()).toString());
            Tuple2[] tups = new Tuple2[this.dictionary().size()];
            Object[] ts = new Object[this.dictionary().size()];
            Iterator mit = this.dictionary().iterator();
            for (i = 0; i < tups.length; ++i) {
                tups[i] = (Tuple2)mit.next();
            }
            Arrays.sort((Object[])tups, CompressionTable$.MODULE$.compareBy2ndValue());
            for (i = 0; i < tups.length; ++i) {
                ScalaRunTime$.MODULE$.array_update((Object)ts, i, tups[i]._1());
            }
            decompressionTable = new DecompressionTable(this.originUid(), this.version(), ts);
        }
        return decompressionTable;
    }

    public <T> CompressionTable<T> copy(long originUid, byte version, Map<T, Object> dictionary) {
        return new CompressionTable<T>(originUid, version, dictionary);
    }

    public <T> long copy$default$1() {
        return this.originUid();
    }

    public <T> byte copy$default$2() {
        return this.version();
    }

    public <T> Map<T, Object> copy$default$3() {
        return this.dictionary();
    }

    public String productPrefix() {
        return "CompressionTable";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToLong((long)this.originUid());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToByte((byte)this.version());
                break;
            }
            case 2: {
                object = this.dictionary();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CompressionTable;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "originUid";
                break;
            }
            case 1: {
                string = "version";
                break;
            }
            case 2: {
                string = "dictionary";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.originUid()));
        n = Statics.mix((int)n, (int)this.version());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.dictionary()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CompressionTable)) return false;
        boolean bl = true;
        if (!bl) return false;
        CompressionTable compressionTable = (CompressionTable)x$1;
        if (this.originUid() != compressionTable.originUid()) return false;
        if (this.version() != compressionTable.version()) return false;
        Map<T, Object> map = this.dictionary();
        Map<T, Object> map2 = compressionTable.dictionary();
        if (map != null) {
            if (!map.equals(map2)) return false;
            return true;
        }
        if (map2 == null) return true;
        return false;
    }

    public CompressionTable(long originUid, byte version, Map<T, Object> dictionary) {
        this.originUid = originUid;
        this.version = version;
        this.dictionary = dictionary;
        Product.$init$((Product)this);
    }
}

