/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.PhaseContainerState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

@XStreamProvider(readable=TaskPreviewBlock.class, tagName="previewblock")
public class TaskPreviewBlockConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TaskPreviewBlock task = (TaskPreviewBlock)source;
        writer.addAttribute("id", task.getId());
        if (task.getBlock() != null) {
            writer.startNode("block");
            Converters.writePhaseContainer((PhaseContainerState)task.getBlock(), writer, context, true);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TaskPreviewBlock block = new TaskPreviewBlock();
        block.setId(reader.getAttribute("id"));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("block".equals(reader.getNodeName())) {
                BlockState blockState = (BlockState)context.convertAnother((Object)block, BlockState.class);
                block.setBlock(blockState);
            }
            reader.moveUp();
        }
        return block;
    }

    public boolean canConvert(Class type) {
        return TaskPreviewBlock.class.isAssignableFrom(type);
    }
}

