/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import java.math.BigInteger;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.CharType;

@DataTypeInfo(name="varchar", aliases={"java.sql.Types.VARCHAR", "java.lang.String", "varchar2", "character varying"}, minParameters=0, maxParameters=1, priority=1)
public class VarcharType
extends CharType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof OracleDatabase || database instanceof HsqlDatabase && ((HsqlDatabase)database).isUsingOracleSyntax()) {
            return new DatabaseDataType("VARCHAR2", this.getParameters());
        }
        if (database instanceof InformixDatabase && this.getSize() > 255) {
            return new DatabaseDataType("LVARCHAR", this.getParameters());
        }
        if (database instanceof MSSQLDatabase) {
            String param1;
            Object[] parameters = this.getParameters();
            if (!(parameters.length <= 0 || (param1 = parameters[0].toString()).matches("\\d+") && new BigInteger(param1).compareTo(BigInteger.valueOf(8000L)) <= 0)) {
                DatabaseDataType type = new DatabaseDataType(database.escapeDataTypeName("varchar"), "MAX");
                type.addAdditionalInformation(this.getAdditionalInformation());
                return type;
            }
            if (parameters.length == 0) {
                parameters = new Object[]{1};
            } else if (parameters.length > 1) {
                parameters = Arrays.copyOfRange(parameters, 0, 1);
            }
            DatabaseDataType type = new DatabaseDataType(database.escapeDataTypeName("varchar"), parameters);
            type.addAdditionalInformation(this.getAdditionalInformation());
            return type;
        }
        if (database instanceof PostgresDatabase && this.getParameters() != null && this.getParameters().length == 1 && "2147483647".equals(this.getParameters()[0].toString())) {
            DatabaseDataType type = new DatabaseDataType("CHARACTER");
            type.addAdditionalInformation("VARYING");
            return type;
        }
        return super.toDatabaseDataType(database);
    }
}

